/*
 * マルチプラットフォーム描画エンジン「Sherry」
 * Copyright(C) 2010-2011 SherryProject. all rights reserved.
 *
 * The MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*
 *	mushroom.c
 *		Copyright (C) 2010-2011 Cap5ule. all rights reserved.
 * 
 *	Date		|Version	|Author		|Summary
 *	2010/02/01	|v0.01		|onakah		|初回版
 */

/*---- インクルードファイル ----*/

#include <use_sherry.h>			//!<Sherryライブラリを使用する

/*---- マクロ定義 ----*/

#define RESISTANCE		(0.6f)	//!<回転抵抗値
#define MUSUROOMNUM		(9)		//!<きのこ最大数（グループ）
int SCREEN_WIDTH	= 800;		//!<タップ判定用、ハードによって変更する
int SCREEN_HEIGHT	= 480;		//!<


/*---- 構造体定義 ----*/


/*---- グローバル変数 ----*/

extern shTexture	g_testTex;		//!<テクスチャデータ
extern shMesh		g_testMesh;		//!<メッシュデータ
extern shShaderProg g_shaderpg;		//!<シェーダプログラム


shVector3	g_axis[9];				//!<きのこ回転軸
float		g_rot[9];				//!<きのこ回転角
shMatrix	g_rotMatrix[9];			//!<きのこ回転行列


/*
 *	void SetWindowSize(int _x, int _y)
 *
 *	ウィンドウのサイズをセットする。
 *	画面情報が変わった時に呼び出す
 */
void SetWindowSize(int _x, int _y)
{
	SCREEN_WIDTH = _x;
	SCREEN_HEIGHT = _y;
}


/*
 *	void InitMushroom(void)
 *
 *	きのこ初期化処理
 */
void InitMushroom(void)
{
	int index;
	for(index = 0; index < MUSUROOMNUM; index ++){
		g_axis[index].x = g_axis[index].y = g_axis[index].z = 0.0f;
		g_rot[index] = 0.0f;
		shMatrixIdentity(&g_rotMatrix[index]);
	}
}


/*
 *	void MoveMushroom(shVector2 vec)
 *
 *	きのこ回転処理
 *	＜引数＞
 *		int isClick		: クリック/タップされているか（0:no / 1:yes）
 *		float _x		: タップされているＸ座標
 *		float _y		: タップされているＹ座標
 *		shVector2 vec	: 移動量
 */
void MoveMushroom(int isClick, float _x, float _y, shVector2 vec)
{
	int				mdlX = 0;		// タップ対象のモデル判定用
	int				mdlY = 0;		// タップ対象のモデル判定用
	int				mdlIndex = -1;	// タップ対象のモデル配列番号
	int				index = 0;		// カウンター
	shQuaternion	quatWork;		// 四元数計算用
	shMatrix		matWork;		// 行列計算用

	if(isClick){
		// タップされている
		if(_x < SCREEN_WIDTH/3){
			mdlX = 0;
		}else if(_x > (SCREEN_WIDTH/3)*2){
			mdlX = 2;
		}else{
			mdlX = 1;
		}
		if(_y < SCREEN_HEIGHT/3){
			mdlY = 0;
		}else if(_y > (SCREEN_HEIGHT/3)*2){
			mdlY = 2;
		}else{
			mdlY = 1;
		}
		// 配列計算
		mdlIndex = mdlY*3+mdlX;
		// ベクトルから四元数を生成する準備
		g_axis[mdlIndex].x = vec.y;
		g_axis[mdlIndex].y = vec.x;
		g_axis[mdlIndex].z = 0.0f;
		g_rot[mdlIndex] = -sqrtf(vec.x*vec.x+vec.y*vec.y)/2.0f;
		shVec3Normalize(&g_axis[mdlIndex]);
	}

	// 
	// 抵抗値で回転速度を減速する
	for(index = 0; index < MUSUROOMNUM; index ++){
		if(index != mdlIndex){
			// 現在所持している物以外を処理する
			if(g_rot[index] < 0){
				g_rot[index] += RESISTANCE;
				if(g_rot[index] > 0){
					g_rot[index] = 0.0f;
				}
			}
			else if(g_rot[index] > 0){
				g_rot[index] -= RESISTANCE;
				if(g_rot[index] < 0){
					g_rot[index] = 0.0f;
				}
			}
		}
	}
//	g_rot /= 1.1f;

	// 回転行列を作成する
	for(index = 0; index < MUSUROOMNUM; index ++){
		// 四元数を生成する
		shQuaternionRotation(&quatWork, TO_RADIAN(g_rot[index]), g_axis[index].x, g_axis[index].y, g_axis[index].z);
		// 四元数→行列
		shQuaternionToMatrix(&matWork, &quatWork);
		// 回転成分を加える
		shMatrixMultiply(&g_rotMatrix[index], &g_rotMatrix[index], &matWork);
	}
}


/*
 *	void UpdateMushroom(void)
 *
 *	きのこ更新処理
 */
void UpdateMushroom(void)
{
}


/*
 *	void DrawMushroom(void)
 *
 *	きのこ描画処理
 */
void DrawMushroom(void)
{
	// ローカル変数
	shMatrix drawmat, drawmat2, drawans;	// 変換用の行列

	//ポリゴン描画
	{
		int ii;
		int iii;
		shVector3 eye,at,up;

		//設定
		eye.x = 0.0f;
		eye.y = 0.0f;
		eye.z = 4.0f;
		at.x = 0.0f;
		at.y = 0.0f;
		at.z = 0.0f;
		up.x = 0.0f;
		up.y = 1.0f;
		up.z = 0.0f;

		// シェーダー適用
		shBeginShader(&g_shaderpg);

		// テクスチャを設定
		shSetTexture(&g_testTex);

		// 行列変換
		shMatrixIdentity(&drawans);	// 単位行列化
		shMatrixPerspectiveFovRH(&drawmat,45,640.0f/480.0f,0.5f,20.0f);
		shLookAtMatrixRH(&drawmat2,&eye,&at,&up);
//		shMatrixMultiply(&drawans,&drawmat2,&drawmat);
//		shMatrixMultiply(&drawans,&g_rotMatrix,&drawans);

		// モデル描画開始
		// モデル群を9個描画する
		for(iii = 0; iii < 9; iii++) {
			shMatrix transMat;

			const shVector3 mdlPos[] = {
				{-2,  1.4f, 0},
				{ 0,  1.4f, 0},
				{ 2,  1.4f, 0},
				{-2,  0, 0},
				{ 0,  0, 0},
				{ 2,  0, 0},
				{-2, -1.4f, 0},
				{ 0, -1.4f, 0},
				{ 2, -1.4f, 0},
			};
			shMatrixMultiply(&drawans,&drawmat2,&drawmat);
			// 平行移動
			shMatrixTranslation(&transMat,mdlPos[iii].x,mdlPos[iii].y,mdlPos[iii].z);
			// 移動
			shMatrixMultiply(&drawans, &transMat, &drawans);
			// 回転
			shMatrixMultiply(&drawans, &g_rotMatrix[iii], &drawans);

			// モデルを十字に9個描画する
			for(ii = 0; ii < 1; ii++) {
				shMatrix drawmat_tran, drawmat_ans;

				const shVector3 pos[] = {
					{0,0,0},
				};

				// 平行移動
				shMatrixTranslation(&drawmat_tran,pos[ii].x,pos[ii].y,pos[ii].z);
				// 行列を計算
				shMatrixMultiply(&drawmat_ans,&drawmat_tran,&drawans);
				// 行列を入れる
				shUniformMatrix(&g_shaderpg,"u_worldViewProjMatrix",&drawmat_ans);

				// 描画
				shDrawMesh(&g_testMesh);
			}
		}

		shEndShader(&g_shaderpg);
	}
}

