﻿/*
 * マルチプラットフォーム描画エンジン「Sherry」
 * Copyright(C) 2010-2011 SherryProject. all rights reserved.
 *
 * The MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*
 *	shSprite.h
 *		Copyright (C) 2010-2011 Cap5ule. all rights reserved.
 *
 *	Date		|Version	|Author		|Summary
 *	2010/11/16	|v0.01		|Cap5ule	|初回版
 */

#ifndef _SH_SPRITE_H_
#define _SH_SPRITE_H_

/*---- インクルードファイル ----*/

#include "shTexture.h"

/*---- マクロ定義 ----*/



/*---- 構造体定義 ----*/



/*---- 外部グローバル変数 ----*/

extern shDrawMode g_sh_DrawMode;		//!<描画モード

/*---- プロトタイプ宣言 ----*/

#ifdef __cplusplus
extern "C" {
#endif

/*
 *	void shInitSprite()
 *
 *	＜引数＞
 *　　なし
 *	＜戻り値＞
 *　　int			: エラーコードが返ります
 *	＜説明＞
 *　　スプライト機能の初期化
 *　　スプライト機能の初期化を行い使用可能にします。
 *　　スプライトを使う前呼び出す必要があります。
 */
int shInitSprite();

/*
 *	void shSetSpritePosition(float x, float y, float z)
 *
 *	＜引数＞
 *　　float x		: Ｘ位置
 *　　float y		: Ｙ位置
 *　　float z		: Ｚ位置（Ｚソート）
 *	＜戻り値＞
 *　　なし
 *	＜説明＞
 *　　スプライトのポジション（位置）とサイズを設定する。
 *　　無駄な計算を省き高速化するため、ポジションとサイズを同じにしている。
 */
void shSetSpritePosition(float x, float y, float z);

/*
 *	void shSetSpriteSize(float w, float h)
 *
 *	＜引数＞
 *		float w		: サイズ横幅
 *		float h		: サイズ縦幅
 *	＜戻り値＞
 *		なし
 *	＜説明＞
 *		スプライトのポジション（位置）とサイズを設定する。
 *		無駄な計算を省き高速化するため、ポジションとサイズを同じにしている。
 */
void shSetSpriteSize(float w, float h);
/*
 *	void shSetSpriteTexCoord(float u, float v, float uw, float vh)
 *
 *	＜引数＞
 *		float u		: Ｕ位置
 *		float v		: Ｖ位置
 *		float uw	: Ｕサイズ横幅
 *		float vh	: Ｖサイズ縦幅
 *	＜戻り値＞
 *		なし
 *	＜説明＞
 *		スプライトのテクスチャ座標を設定する。
 */
void shSetSpriteTexCoord(float u, float v, float uw, float vh);

/*
 *	void shSetSpriteRotate(float angdeg)
 *
 *	＜引数＞
 *		float angdeg	: 回転角（DEGREE）
 *	＜戻り値＞
 *		なし
 *	＜説明＞
 *		スプライトのテクスチャ座標を設定する。
 */
void shSetSpriteRotate(float angdeg);

/*
 *	void shSetSpriteScSize(float w, float h)
 *
 *	＜引数＞
 *		float w		: サイズ横幅
 *		float h		: サイズ縦幅
 *	＜戻り値＞
 *		なし
 *	＜説明＞
 *		スプライトのスクリーンサイズを設定する。
 *		個別に設定しておくことで、実画面サイズに依存せず表示可能になります。
 */
void shSetSpriteScSize(float w, float h);

/*
 *	void shSetSpriteColor(float r, float g, float b, float a)
 *
 *	＜引数＞
 *		float r		: 赤（0.0～1.0）
 *		float g		: 緑（0.0～1.0）
 *		float b		: 青（0.0～1.0）
 *		float a		: アルファ値（0.0～1.0）
 *	＜戻り値＞
 *		なし
 *	＜説明＞
 *		スプライトの色を設定する。
 */
void shSetSpriteColor(float r, float g, float b, float a);

/*
 *	void shSetSpriteTexture(shTexture* texture)
 *
 *	＜引数＞
 *　　shTexture* texture	: テクスチャ構造体
 *	＜戻り値＞
 *　　なし
 *	＜説明＞
 *　　スプライトのテクスチャを設定する。
 */
void shSetSpriteTexture(shTexture* texture);

/*
 *	void shSpriteDraw()
 *
 *	＜引数＞
 *　　なし
 *	＜戻り値＞
 *　　なし
 *	＜説明＞
 *　　設定に基づいてスプライトを描画します。
 */
void shSpriteDraw();

#ifdef __cplusplus
}
#endif

#endif /*_SH_SPRITE_H_*/
