package jp.ac.titech.sharp4k.cuten;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.ExpandableListView.OnChildClickListener;
import android.widget.ExpandableListView.OnGroupClickListener;
import android.widget.ImageButton;
import android.widget.SimpleExpandableListAdapter;

import com.google.inject.Inject;

public class RecordActivity extends BaseMenuActivity {
	private static final String TAG = RecordActivity.class.getSimpleName();

	private ImageButton updateBtn, returnBtn;
	private ExpandableListView recordList;

	private SQLiteDatabase db;

	@Inject
	private HttpAPIClient apiClient;
	private ProgressDialog progressDialog;
	private AlertDialog alertDialog;

	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.record);

		updateBtn = (ImageButton) findViewById(R.id.record_update_btn);
		returnBtn = (ImageButton) findViewById(R.id.record_return_btn);
		recordList = (ExpandableListView) findViewById(R.id.record_expandable_view);

		SQLHelper sqlhelper = new SQLHelper(this);
		db = sqlhelper.getReadableDatabase();

		setActionListener();
		getArrayAdapter();

		progressDialog = new ProgressDialog(this);
		progressDialog.setTitle("通信中");
		progressDialog.setMessage("実績情報を更新しています");
		progressDialog.setProgressStyle(ProgressDialog.STYLE_SPINNER);
		progressDialog.setCancelable(false);

		alertDialog = new AlertDialog.Builder(this).setTitle("エラー")
				.setCancelable(false).setPositiveButton("OK", null).create();
	}

	public void onDestroy() {
		super.onDestroy();
		db.close();
	}

	private void setActionListener() {
		updateBtn.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				progressDialog.show();
				apiClient.getAchievements(Token.load(getApplicationContext()),
						new SimpleHttpResponseListener() {
							@Override
							public void preExec() {
								progressDialog.dismiss();
							}

							@Override
							public void onSuccess(String body) {
								try {
									JSONArray root = new JSONArray(body);
									for (int i = 0; i < root.length(); i++) {
										JSONObject obj = root.getJSONObject(i);
										Task task = Task.find(db,
												obj.getInt("task_id"));
										if (task == null) {
											// Maybe the user haven't updated
											// task's information
											continue;
										}
										Achievement achievement = new Achievement(
												task, obj.getString("result"));
										achievement.setSubmitted(true);
										achievement.replace(db);
									}
									getArrayAdapter();
								} catch (JSONException e) {
									Log.e(TAG,
											"JSONException: " + e.getMessage());
									Log.e(TAG, body);
								}
							}

							@Override
							public void onUnauthorized() {
								alertDialog.setMessage("不正なトークンです");
								alertDialog.show();
							}

							@Override
							public void onFailure(Exception e) {
								alertDialog.setMessage(e.getMessage());
								alertDialog.show();
							}
						});
			}
		});

		returnBtn.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				finish();
			}
		});

		recordList.setOnGroupClickListener(new OnGroupClickListener() {
			@Override
			public boolean onGroupClick(ExpandableListView parent, View v,
					int groupPosition, long id) {
				if (parent.expandGroup(groupPosition)) {
					for (int i = 0; i < parent.getExpandableListAdapter()
							.getGroupCount(); i++) {
						if (i != groupPosition) {
							parent.collapseGroup(i);
						}
					}
				} else {
					parent.collapseGroup(groupPosition);
				}
				return true;
			}
		});

		recordList.setOnChildClickListener(new OnChildClickListener() {
			@Override
			public boolean onChildClick(ExpandableListView arg0, View arg1,
					int arg2, int arg3, long arg4) {
				// 詳細表示とか入れる？
				return false;
			}
		});
	}

	private void getArrayAdapter() {
		String lectureKey = "lecture";
		String taskKey = "task";
		String resultKey = "result";

		List<Lecture> lecList = Lecture.findSelectedAll(db);

		ArrayList<Map<String, String>> lecNameList = new ArrayList<Map<String, String>>();
		ArrayList<List<Map<String, String>>> taskList = new ArrayList<List<Map<String, String>>>();

		for (int i = 0; i < lecList.size(); i++) {
			Lecture lec = lecList.get(i);
			List<Task> tasks = lec.findTasks(db);

			Map<String, String> lecName = new HashMap<String, String>();
			lecName.put(lectureKey, lec.getName());
			lecNameList.add(lecName);
			{
				List<Map<String, String>> taskNameList = new ArrayList<Map<String, String>>();
				for (Task task : tasks) {
					Achievement a = Achievement.find(db, task);
					String result = a == null ? "" : a.getResultString();

					Map<String, String> taskName = new HashMap<String, String>();
					taskName.put(taskKey, task.getName());
					taskName.put(resultKey, result);
					taskNameList.add(taskName);
				}
				taskList.add(taskNameList);
			}
		}
		ExpandableListAdapter adapter = new SimpleExpandableListAdapter(this,
				lecNameList, android.R.layout.simple_expandable_list_item_1,
				new String[] { lectureKey }, new int[] { android.R.id.text1 },
				taskList, android.R.layout.simple_expandable_list_item_2,
				new String[] { taskKey, resultKey }, new int[] {
						android.R.id.text1, android.R.id.text2 });

		recordList.setAdapter(adapter);
	}
}
