package your.example.folder.util;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlSerializer;

import your.example.folder.LectureFolderActivity;
import android.content.Context;
import android.util.Log;
import android.util.Xml;




public class XmlUtility {

	private static final String fileName = "folder.xml";

	private static final String FOLDER_TAG_NAME = "folder";
	private static final String FOLDER_ATTRIBUTE_NAME = "name";
	private static final String DEFAULT_FOLDER_ATTRIBUTE = "default";
	private static final String LECTURE_TAG_NAME = "lecture";
	private static final String LECTURE_ATTRIBUTE_NAME = "name";
	private static final String DOCUMENT_TAG_NAME = "document";

	public static Map<String, Object> readXmlFile(Context context){
		Map<String, Object> listMap = new HashMap<String, Object>();

		List<Map<String, Object>> folderList = new ArrayList<Map<String, Object>>();
		List<List<Map<String, Object>>> allLectureList = new ArrayList<List<Map<String, Object>>>();
		Map<String, Object> defaultFolder = null;

		try{
			XmlPullParser parser = Xml.newPullParser();

			InputStream is = context.openFileInput(fileName);
			InputStreamReader reader = new  InputStreamReader(is);
			parser.setInput(reader);

			List<Map<String, Object>> lectureList = null;
			Map<String, Object> lecture = null;


			for(int type = parser.getEventType(); type != XmlPullParser.END_DOCUMENT; type = parser.next()){

				switch(type){
				case XmlPullParser.START_TAG:{
					Log.d(FOLDER_TAG_NAME, parser.getName());
					if(parser.getName().equals(FOLDER_TAG_NAME)){
						Map<String, Object> folder = new HashMap<String, Object>();
						folder.put(LectureFolderActivity.PARENT_KEY, parser.getAttributeValue("", FOLDER_ATTRIBUTE_NAME));
						folderList.add(folder);
						if(parser.getAttributeValue("", DEFAULT_FOLDER_ATTRIBUTE) != null){
							folder.put(LectureFolderActivity.PARENT_DEFAULT, LectureFolderActivity.PARENT_DEFAULT);
							defaultFolder = folder;
						}

						lectureList = new ArrayList<Map<String, Object>>();
					}else if(parser.getName().equals(LECTURE_TAG_NAME)){
						lecture = new HashMap<String, Object>();
						lecture.put(LectureFolderActivity.CHILD_KEY, parser.getAttributeValue("", LECTURE_ATTRIBUTE_NAME));

					}
					break;
				}
				case XmlPullParser.TEXT:{
					lecture.put(LectureFolderActivity.CHILD_SUMMERY, parser.getText());
					break;
				}
				case XmlPullParser.END_TAG:{
					if(parser.getName().equals(FOLDER_TAG_NAME)){
						allLectureList.add(lectureList);
					}else if(parser.getName().equals(LECTURE_TAG_NAME)){
						lectureList.add(lecture);
					}break;
				}
				}
			}

		}catch(Exception e){
			e.printStackTrace();
		}
		listMap.put("PARENT", folderList);
		listMap.put("LECTURE", allLectureList);
		listMap.put("DEFAULT", defaultFolder);

		return listMap;
	}

	public static void writeXmlFile(Context context, Map<String, Object> map){
		List<Map<String, Object>> parentList = (List<Map<String, Object>>) map.get("PARENT");
		List<List<Map<String, Object>>> allLectureList = (List<List<Map<String, Object>>>) map.get("LECTURE");
		Map<String, Object> defaultFolder = (Map<String, Object>) map.get("DEFAULT");

		try {
		XmlSerializer serializer = Xml.newSerializer();


		FileOutputStream os = context.openFileOutput(fileName, Context.MODE_WORLD_READABLE);
		serializer.setOutput( os, "UTF-8" );

		serializer.startDocument("UTF-8", true);
		//データ入力
		serializer.startTag("", DOCUMENT_TAG_NAME);

		for(int i = 0; i < parentList.size(); i++){
			Map<String, Object> folder = parentList.get(i);
			List<Map<String, Object>> lectureList = allLectureList.get(i);

			serializer.startTag("", FOLDER_TAG_NAME);
			Log.d("Lecture", FOLDER_TAG_NAME);
			serializer.attribute("", FOLDER_ATTRIBUTE_NAME, (String)folder.get(LectureFolderActivity.PARENT_KEY));
			if(folder.equals(defaultFolder)){
				serializer.attribute("", DEFAULT_FOLDER_ATTRIBUTE, DEFAULT_FOLDER_ATTRIBUTE);
			}
			Log.d("Lecture", (String)folder.get(LectureFolderActivity.PARENT_KEY));
			for(int j = 0; j < lectureList.size(); j++){
				Map<String, Object> lecture = lectureList.get(j);
				serializer.startTag("", LECTURE_TAG_NAME);
				Log.d("Lecture", LECTURE_TAG_NAME);
				serializer.attribute("", LECTURE_ATTRIBUTE_NAME, (String)lecture.get(LectureFolderActivity.CHILD_KEY));
				Log.d("Lecture", (String)lecture.get(LectureFolderActivity.CHILD_KEY));
				serializer.text((String)lecture.get(LectureFolderActivity.CHILD_SUMMERY));
				Log.d("Lecture", (String)lecture.get(LectureFolderActivity.CHILD_SUMMERY));
				serializer.endTag("", LECTURE_TAG_NAME);
			}
			serializer.endTag("", FOLDER_TAG_NAME);
		}

		serializer.endTag("", DOCUMENT_TAG_NAME);
		serializer.endDocument();
		//ファイルに出力
		serializer.flush();

		os.close();
		Log.d("Lecture", "writeOK!");
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
