require 'test_helper'

class AccessAchievementJsonTest < ActionDispatch::IntegrationTest
  setup do
    @user = FactoryGirl.create :user
    @auth_token = @user.authentication_token
    @task = FactoryGirl.create :task
  end

  test 'get achievements' do
    FactoryGirl.create :achievement, :user => @user, :task => @task
    get "/achievements.json", :auth_token => @auth_token
    assert_response :success
    as = JSON.parse @response.body
    assert_equal @user.achievements.map(&:result).sort, as.map { |a| a['result'] }.sort
  end

  test 'add an achievement' do
    put "/tasks/#{@task.id}/achievement.json", :auth_token => @auth_token, :achievement => { :result => '100' }
    assert_response :success
    j = JSON.parse @response.body
    assert_equal @task.id, j['task_id']
    assert_equal '100', j['result']
  end

  test 'update an achievement' do
    put "/tasks/#{@task.id}/achievement.json", :auth_token => @auth_token, :achievement => { :result => '1, 4, 7' }
    assert_response :success

    put "/tasks/#{@task.id}/achievement.json", :auth_token => @auth_token, :achievement => { :result => '2,0,10' }
    assert_response :success

    get "/tasks/#{@task.id}/achievement.json", :auth_token => @auth_token
    achievement = JSON.parse @response.body
    assert_equal '2,4,10', achievement['result']
  end

  test 'failed to update an achievement' do
    put "/tasks/#{@task.id}/achievement.json", :auth_token => @auth_token, :achievement => { :result => '1, 4, 7' }
    assert_response :success

    put "/tasks/#{@task.id}/achievement.json", :auth_token => @auth_token, :achievement => { :result => '2,0' }
    assert_response 422
    j = JSON.parse @response.body
    assert j.has_key?('result')

    get "/tasks/#{@task.id}/achievement.json", :auth_token => @auth_token
    achievement = JSON.parse @response.body
    assert_equal '1,4,7', achievement['result']
  end

  test 'create new achievement via /tasks/:task_id/achievement' do
    assert_difference('Achievement.count') do
      put "/tasks/#{@task.id}/achievement.json", :auth_token => @auth_token, :achievement => { :result => '1, 4, 7' }
    end
    assert_response :success
    achievement = JSON.parse @response.body
    assert_equal achievement['task_id'], @task.id
  end
end
