<?php

require('os_dbparam.inc');

class DBConnection {

	private $db = null;
	private $ConnectFlg = False;
	private $DBparam = null;
	private $DBUser = null;
	private $DBPassWD = null;

	public function __construct() {

		$this->DBparam = DB_CON_TYPE . ':dbname=' . DB_CON_NAME . ';host=' . DB_CON_HOST . ' port=' . DB_CON_PORT;
		$this->DBUser = DB_CON_USER;
		$this->DBPassWD = DB_CON_PASS;

		$this->Connect();
	}

	public function __destruct() {
		$db = null;
	}

	public function Connect() {

		if (! $this->ConnectFlg) {
			$this->DisConnect();
		}

		$this->db = new PDO($this->DBparam, $this->DBUser, $this->DBPassWD);
	    $this->db->query('DB_CHAR_SET');
		$this->ConnectFlg = True;
	}

	public function DisConnect() {

		$this->db = null;
		$this->ConnectFlg = False;
	}

	public function Connected() {

		return $this->ConnectFlg;
	}

	public function AssignDBConnection($DBsession){

		$DBsession->SetDBConnection($this->db);
	}
}

class DBSession {

	private $Db = null;

	public function __construct($DBConnection = null) {

		if (! is_null($DBConnection)) {
			$this->SetDBConnection($DBConnection);
		}
	}

	public function __destruct() {

	}

	public function SetDBConnection($DBConnection) {

		$this->Db = $DBConnection;
	}

	private function setBindParam(&$s, &$param) {

		if (! empty($param)) {
			foreach ($param as $key => $value) {
				$s->bindParam("$key", $value);
			}
		}
	}

	public function query_select(&$sql, &$param) {

		$s = $this->Db->prepare($sql);
		$this->setBindParam($s, $param);

		if (! $s->execute($param)) {
			throw new Exception('0030001', SYSTEM_ERROR);
		}

		return $s->fetchAll();

	}

	public function query_update(&$sql, &$param) {

		$s = $this->Db->prepare($sql);
		$this->setBindParam($s, $param);

		if (! $s->execute($param)) {
			throw new Exception('0030002', SYSTEM_ERROR);
		}

		return $s->rowCount();

	}
}

