<?php

final class clientData {

	const EM_POST = '$_POST';
	const EM_GET = '$_GET';
	const RM_GET = 'GET';

	private $cPost =null;

	public $cmdNo = null;
	public $cmdType = null;
	public $userID = null;
	public $roomID = null;
	public $osSession = null;

	private function paramCheck() {

		$cPost = str_replace("\0", "", $cPost);

	}

	private function getRequestMethod() {

		switch ($_SERVER['REQUEST_METHOD']) {
			case 'post':
					$em = EM_POST;
				break;
			case 'get':
					if (ENV_IS_TEST_MODE && $_GET['rm_mode'] === RM_GET) {
						$em = EM_GET;
						break;
					}
			default:
				throw new Exception('00101', SYSTEM_ERROR);
		}

		$cPost = $$em;
		$this->paramCheck();

//		$$em = null;

	}

	private function setParam() {

		$this->getRequestMethod();

		$cmdNo = $cPost['data'];
		$userID = $cPost['userid'];
		$roomID = $cPost['roomid'];
		$osSession = $cPost['sessionid'];

		$this->commonParamCheck();

	}

	private function commonParamCheck() {

		$this->cmdCheck();
		$this->userIDCheck();
		$this->roomIDCheck();
		$this->osSessionCheck();

	}

	private function cmdCheck() {

		if (! preg_match('/^[A-Z]/', $cmdNo)) {
			throw new Exception('00101', SYSTEM_ERROR);
		}

		if (! ctype_alnum($cmdNo)) {
			throw new Exception('00101', SYSTEM_ERROR);
		}

		if (strlen($cmdNo) != CMD_CNT) {
			throw new Exception('00100', SYSTEM_ERROR);
		}

	}

	private function userIDCheck(){

		if (! ctype_alnum($userID)) {
			throw new Exception('00100', SYSTEM_ERROR);
		}

		if (strlen($userID) != USERID_CNT) {
			throw new Exception('00100', SYSTEM_ERROR);
		}

		if (substr($userID, 0, 1) != USERID_PREFIX) {
			throw new Exception('00101', SYSTEM_ERROR);
		}

	}

	private function roomIDCheck() {

		if (! ctype_digit($roomID)) {
			throw new Exception('00200', SYSTEM_ERROR);
		}

	}

	private function osSessionCheck() {

		if (! ctype_alnum($osSession)) {
			throw new Exception('00100', SYSTEM_ERROR);
		}

	}

	public function __construct() {

		$this->setParam();
		$this->cmdType = substr($cmdNo, 0, 1);
	}

	public function __destruct() {

	}

}