﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.IO;
using Microsoft.VisualBasic.PowerPacks;

using SME_CD;
using SystemCommon;


namespace 最妙性格診断
{
	public partial class F03回答入力 : Form
	{
		////////////////////////////////////////////////////////////////////////
		// メンバ変数
		////////////////////////////////////////////////////////////////////////
		#region メンバ変数

		private static Label[] lbl設問No = new Label[120];
		private static TextBox[] txt設問 = new TextBox[120];
		private static LineShape[] lin設問 = new LineShape[120];
		private static ShapeContainer shapeContainer2 = new ShapeContainer();

		private static Panel[] pnl回答 = new Panel[120];
		private static RadioButton[] rdoはい = new RadioButton[120];
		private static RadioButton[] rdoどちらともいえない = new RadioButton[120];
		private static RadioButton[] rdoいいえ = new RadioButton[120];
		private static RadioButton[] rdo訂正回答 = new RadioButton[120];
		private static RadioButton[] rdo未回答 = new RadioButton[120];

		#endregion


		////////////////////////////////////////////////////////////////////////
		// 共通メソッド 
		////////////////////////////////////////////////////////////////////////
		#region 公開 共通メソッド

		public F03回答入力()
		{
			InitializeComponent();
		}

		#endregion

		////////////////////////////////////////////////////////////////////////
		// 非公開 共通メソッド
		////////////////////////////////////////////////////////////////////////
		#region 非公開 共通メソッド

		private static void 設問に内容を表示()
		{
			byte iCnt = 0;
			txt設問[iCnt++].Text = "色々な人と知り合いになるのが楽しみ。";
			txt設問[iCnt++].Text = "人中ではいつも後の方に引込んでいる。";
			txt設問[iCnt++].Text = "むずかしい問題を考えるのが好きである。";
			txt設問[iCnt++].Text = "色々違う仕事がしてみたい。";
			txt設問[iCnt++].Text = "周囲の人とうまく調子を合わせていく。";
			txt設問[iCnt++].Text = "いつも何かしていないと気がすまない。";
			txt設問[iCnt++].Text = "世の中の人は人のことなどかまわないと思う。";
			txt設問[iCnt++].Text = "わけもなく喜んだり悲しんだりする。";
			txt設問[iCnt++].Text = "人が見ていると仕事ができない。";
			txt設問[iCnt++].Text = "失敗しやしないかといつも心配である。";
			txt設問[iCnt++].Text = "気持ちを顔にあらわしやすい。";
			txt設問[iCnt++].Text = "時々何に対しても興味がなくなる。";
			txt設問[iCnt++].Text = "知らぬ人と話すときはかたくなる。";
			txt設問[iCnt++].Text = "会などの時は人の先に立って働く。";
			txt設問[iCnt++].Text = "1人きりでいたいと思うことが時々ある。";
			txt設問[iCnt++].Text = "計画を立てるよりも早く実行がしたい。";
			txt設問[iCnt++].Text = "短い時間に沢山の仕事をする自身がある。";
			txt設問[iCnt++].Text = "正しいと思うことは人にかまわず実行する。";
			txt設問[iCnt++].Text = "スパイのような人がたくさんいる。";
			txt設問[iCnt++].Text = "心配で眠れないことがたびたびある。";
			txt設問[iCnt++].Text = "人が来てうるさいと思うことがたびたびある。";
			txt設問[iCnt++].Text = "なかなか決心がつかず機会を失う事が多い。";
			txt設問[iCnt++].Text = "興奮するとすぐ涙が出る。";
			txt設問[iCnt++].Text = "人中にいてもふとさびしくなることがある。";
			txt設問[iCnt++].Text = "こちらから進んで友達を作ることが少ない。";
			txt設問[iCnt++].Text = "会やグループの為に働くのがたのしみである。";
			txt設問[iCnt++].Text = "人のすることの裏を考えることが多い。";
			txt設問[iCnt++].Text = "じっとおとなしくしているのが苦手である。";
			txt設問[iCnt++].Text = "人に対してはいつも気軽に返事ができる。";
			txt設問[iCnt++].Text = "目上の人とも遠慮なく議論することがある。";
			txt設問[iCnt++].Text = "親友でもほんとうに信用することはできない。";
			txt設問[iCnt++].Text = "いやな人と道で出会うと避けて通る。";
			txt設問[iCnt++].Text = "すぐ感情を傷つけられやすい。";
			txt設問[iCnt++].Text = "人から邪魔にされはしないかと心配である。";
			txt設問[iCnt++].Text = "早く決心すればよかったと悔やむことが多い。";
			txt設問[iCnt++].Text = "時々自分をつまらぬ人間だと思うことがある。";
			txt設問[iCnt++].Text = "人目に立つようなことは好ましくない。";
			txt設問[iCnt++].Text = "自分で話すより、人の話を聞く方である。";
			txt設問[iCnt++].Text = "実行する前に考えなおしてみることが多い。";
			txt設問[iCnt++].Text = "いつも何か刺激を求める。";
			txt設問[iCnt++].Text = "困ることがあっても、ほがらかでいられる。";
			txt設問[iCnt++].Text = "衝動的である（自分がおさえられない）。";
			txt設問[iCnt++].Text = "人が見ていないと大抵の人は怠けると思う。";
			txt設問[iCnt++].Text = "とてもありそうもないことを空想する。";
			txt設問[iCnt++].Text = "人の品行（行い）が気になるたちである。";
			txt設問[iCnt++].Text = "人前で顔が赤くなるので困ることが多い。";
			txt設問[iCnt++].Text = "気分がしばしば動揺する。";
			txt設問[iCnt++].Text = "理由もなく不安になることが時々ある。";
			txt設問[iCnt++].Text = "異性（男なら女）の友達はほとんどできない。";
			txt設問[iCnt++].Text = "世話役はいつも人に頼むことにしている。";
			txt設問[iCnt++].Text = "会話の最中にふと考えこむくせがある。";
			txt設問[iCnt++].Text = "よく考えずに行動してしまうことが多い。";
			txt設問[iCnt++].Text = "てきぱきと物事をかたずける。";
			txt設問[iCnt++].Text = "失礼なことをされると黙っていない。";
			txt設問[iCnt++].Text = "人の親切には下心がありそうで不安である。";
			txt設問[iCnt++].Text = "頭がよくなったり、悪くなったりきまらない。";
			txt設問[iCnt++].Text = "人から見られているようで不安である。";
			txt設問[iCnt++].Text = "劣等感（人に劣る感じ）になやまされる。";
			txt設問[iCnt++].Text = "ちょっとしたことでひどく驚くことがある。";
			txt設問[iCnt++].Text = "たびたび物思いに沈むことがある。";
			txt設問[iCnt++].Text = "人と広くつきあうのが好きである。";
			txt設問[iCnt++].Text = "目上の人の前に出るとかたくなる。";
			txt設問[iCnt++].Text = "何でもよく考えてみないと気がすまない。";
			txt設問[iCnt++].Text = "人といっしょにはしゃぐことが多い。";
			txt設問[iCnt++].Text = "仕事は人よりずっと速い方である。";
			txt設問[iCnt++].Text = "平凡に暮らすより何か変わったことがしたい。";
			txt設問[iCnt++].Text = "人は結局利欲の為に働くのだと思う。";
			txt設問[iCnt++].Text = "たびたび寝つかれないで困ることがある。";
			txt設問[iCnt++].Text = "ちょっとしたことが仕事の邪魔になる。";
			txt設問[iCnt++].Text = "人と違うことは恥ずかしくてできない。";
			txt設問[iCnt++].Text = "時々気が散って考えがまとまらない。";
			txt設問[iCnt++].Text = "たびたび過去の失敗をくよくよと考える。";
			txt設問[iCnt++].Text = "誰とでもよく話す。";
			txt設問[iCnt++].Text = "引込みじあんである。";
			txt設問[iCnt++].Text = "用心深いたちである。";
			txt設問[iCnt++].Text = "口数が多い方である。";
			txt設問[iCnt++].Text = "いきいきしている。";
			txt設問[iCnt++].Text = "気が短い。";
			txt設問[iCnt++].Text = "不満が多い。";
			txt設問[iCnt++].Text = "時々誰かに打ち明け話がしたい。";
			txt設問[iCnt++].Text = "神経質である。";
			txt設問[iCnt++].Text = "すぐうろたえるたちである。";
			txt設問[iCnt++].Text = "気が変わりやすい。";
			txt設問[iCnt++].Text = "いつも疲れた気持ちである。";
			txt設問[iCnt++].Text = "新しい友達はなかなかできない。";
			txt設問[iCnt++].Text = "人のあつかいがうまい。";
			txt設問[iCnt++].Text = "たびたび考えこむくせがある。";
			txt設問[iCnt++].Text = "お祭りさわぎが好きである。";
			txt設問[iCnt++].Text = "新しいことにもすぐなれる。";
			txt設問[iCnt++].Text = "軽蔑されたと思うとひどく腹が立つ。";
			txt設問[iCnt++].Text = "たびたび人の気持ちを確かめてみたい。";
			txt設問[iCnt++].Text = "時々ポカンとしていることがある。";
			txt設問[iCnt++].Text = "心配性である。";
			txt設問[iCnt++].Text = "困難にぶつかると気がくじける。";
			txt設問[iCnt++].Text = "こうふんしやすい。";
			txt設問[iCnt++].Text = "たびたびゆううつになる。";
			txt設問[iCnt++].Text = "無口である。";
			txt設問[iCnt++].Text = "はにかみやである。";
			txt設問[iCnt++].Text = "のんきなたちである。";
			txt設問[iCnt++].Text = "早合点の傾向がある。";
			txt設問[iCnt++].Text = "大体いつも機嫌がよい。";
			txt設問[iCnt++].Text = "色々な世間の活動がしてみたい。";
			txt設問[iCnt++].Text = "自分はいつも運が悪い。";
			txt設問[iCnt++].Text = "空想にふけるのが楽しみである。";
			txt設問[iCnt++].Text = "気むずかしい。";
			txt設問[iCnt++].Text = "何かにつけて自信がない。";
			txt設問[iCnt++].Text = "すぐ不機嫌になる。";
			txt設問[iCnt++].Text = "ぼんやり考えこむくせがある。";
			txt設問[iCnt++].Text = "人中に出てもまごつかない。";
			txt設問[iCnt++].Text = "人前で話すのは気がひける。";
			txt設問[iCnt++].Text = "深く物事を考える傾向がある。";
			txt設問[iCnt++].Text = "気がるなたちである。";
			txt設問[iCnt++].Text = "動作がきびきびしている。";
			txt設問[iCnt++].Text = "退屈な時は何か強い刺激を求める。";
			txt設問[iCnt++].Text = "人は私を十分に認めてくれない。";
			txt設問[iCnt++].Text = "座っていても気分が落ち着かない。";
			txt設問[iCnt++].Text = "小さいことを気に病む。";
			txt設問[iCnt++].Text = "あまり迷わず決心がつく。";
			txt設問[iCnt++].Text = "感情的である。";
			txt設問[iCnt++].Text = "たびたび元気がなくなる。";
		}

		private bool 入力チェック()
		{
			if (rdo男性.Checked == false && rdo女性.Checked == false)
			{
				MessageBox.Show("「性別」欄が入力されていません。"
					, "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
				return false;
			}

			for (byte iCnt = 0; iCnt < 120; iCnt++)
			{
				if (rdoはい[iCnt].Checked == false &&
					rdoどちらともいえない[iCnt].Checked == false &&
					rdoいいえ[iCnt].Checked == false &&
					rdo訂正回答[iCnt].Checked == false &&
					rdo未回答[iCnt].Checked == false)
				{
					MessageBox.Show("「Q" + (iCnt + 1).ToString() + "」設問の回答が入力されていません。"
						, "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
					return false;
				}
			}

			return true;
		}

		private void 回答生成(out string str性別, out string str回答)
		{
			str性別 = "";
			if (rdo男性.Checked == true)
				str性別 = rdo男性.Text;
			else if (rdo女性.Checked == true)
				str性別 = rdo女性.Text;

			str回答 = "";
			for (byte iCnt = 0; iCnt < 120; iCnt++)
			{
				if (rdoはい[iCnt].Checked == true)
					str回答 += rdoはい[iCnt].Text + "\t";
				else if (rdoどちらともいえない[iCnt].Checked == true)
					str回答 += rdoどちらともいえない[iCnt].Text + "\t";
				else if (rdoいいえ[iCnt].Checked == true)
					str回答 += rdoいいえ[iCnt].Text + "\t";
				else if (rdo訂正回答[iCnt].Checked == true)
					str回答 += rdo訂正回答[iCnt].Text + "\t";
				else if (rdo未回答[iCnt].Checked == true)
					str回答 += rdo未回答[iCnt].Text + "\t";
			}
		}

		private static void Create回答入力()
		{
			shapeContainer2.Location = new System.Drawing.Point(0, 0);
			shapeContainer2.Margin = new System.Windows.Forms.Padding(0);
			shapeContainer2.Name = "shapeContainer1";
			shapeContainer2.Size = new System.Drawing.Size(816, 352);
			shapeContainer2.TabIndex = 8;
			shapeContainer2.TabStop = false;

			for (byte iCnt = 0; iCnt < 120; iCnt++)
			{
				lbl設問No[iCnt] = new Label();
				txt設問[iCnt] = new TextBox();
				lin設問[iCnt] = new LineShape();

				pnl回答[iCnt] = new Panel();
				rdoはい[iCnt] = new RadioButton();
				rdoどちらともいえない[iCnt] = new RadioButton();
				rdoいいえ[iCnt] = new RadioButton();
				rdo訂正回答[iCnt] = new RadioButton();
				rdo未回答[iCnt] = new RadioButton();

				lbl設問No[iCnt].Location = new Point(
					10,
					60 * iCnt + 10);
				lbl設問No[iCnt].Size = new Size(
					50,
					20);
				lbl設問No[iCnt].Text = "Q" + (iCnt + 1).ToString() + ".";
				lbl設問No[iCnt].Font = new Font("MS UI Gothic", 12F, FontStyle.Regular, GraphicsUnit.Point, ((byte)(128)));

				txt設問[iCnt].Location = new Point(
					lbl設問No[iCnt].Location.X + lbl設問No[iCnt].Size.Width + 1,
					lbl設問No[iCnt].Location.Y);
				txt設問[iCnt].Size = new Size(
					430,
					31);
				txt設問[iCnt].BorderStyle = BorderStyle.None;
				txt設問[iCnt].Font = new Font("MS UI Gothic", 12F, FontStyle.Regular, GraphicsUnit.Point, ((byte)(128)));
				txt設問[iCnt].Multiline = true;
				txt設問[iCnt].Name = "txt設問" + iCnt.ToString();
				txt設問[iCnt].ReadOnly = true;
				txt設問[iCnt].TabIndex = 7;
				txt設問[iCnt].TabStop = false;
				txt設問[iCnt].Text = "";
				txt設問[iCnt].BackColor = SystemColors.Window;

				pnl回答[iCnt].SuspendLayout();

				pnl回答[iCnt].Location = new Point(
					txt設問[iCnt].Location.X + txt設問[iCnt].Size.Width + 1,
					txt設問[iCnt].Location.Y);
				pnl回答[iCnt].Size = new Size(
					280,
					44);
				pnl回答[iCnt].Name = "pnl回答" + iCnt.ToString();
				pnl回答[iCnt].TabIndex = 4;
				pnl回答[iCnt].BorderStyle = BorderStyle.None;

				shapeContainer2.Shapes.AddRange(new Shape[] { lin設問[iCnt] });
				lin設問[iCnt].Name = "lin設問" + iCnt.ToString();
				lin設問[iCnt].X1 = lbl設問No[iCnt].Location.X;
				lin設問[iCnt].X2 = lbl設問No[iCnt].Size.Width + txt設問[iCnt].Size.Width + pnl回答[iCnt].Size.Width + 20;
				lin設問[iCnt].Y1 = txt設問[iCnt].Location.Y - 4;
				lin設問[iCnt].Y2 = txt設問[iCnt].Location.Y - 4;

				pnl回答[iCnt].Controls.Add(rdoはい[iCnt]);
				rdoはい[iCnt].Location = new Point(
					0,
					0);
				rdoはい[iCnt].Size = new Size(
					60,
					20);
				rdoはい[iCnt].AutoSize = false;
				rdoはい[iCnt].Name = "rdoはい" + iCnt.ToString();
				rdoはい[iCnt].TabIndex = 1;
				rdoはい[iCnt].TabStop = true;
				rdoはい[iCnt].Text = "はい";
				rdoはい[iCnt].UseVisualStyleBackColor = true;
				rdoはい[iCnt].Font = new Font("MS UI Gothic", 12F, FontStyle.Regular, GraphicsUnit.Point, ((byte)(128)));

				pnl回答[iCnt].Controls.Add(rdoどちらともいえない[iCnt]);
				rdoどちらともいえない[iCnt].Location = new Point(
					rdoはい[iCnt].Location.X + rdoはい[iCnt].Size.Width + 5,
					rdoはい[iCnt].Location.Y);
				rdoどちらともいえない[iCnt].Size = new Size(
					150,
					rdoはい[iCnt].Size.Height);
				rdoどちらともいえない[iCnt].AutoSize = false;
				rdoどちらともいえない[iCnt].Name = "rdoどちらともいえない" + iCnt.ToString();
				rdoどちらともいえない[iCnt].TabIndex = 2;
				rdoどちらともいえない[iCnt].TabStop = true;
				rdoどちらともいえない[iCnt].Text = "どちらともいえない";
				rdoどちらともいえない[iCnt].UseVisualStyleBackColor = true;
				rdoどちらともいえない[iCnt].Font = new Font("MS UI Gothic", 12F, FontStyle.Regular, GraphicsUnit.Point, ((byte)(128)));

				pnl回答[iCnt].Controls.Add(rdoいいえ[iCnt]);
				rdoいいえ[iCnt].Location = new Point(
					rdoどちらともいえない[iCnt].Location.X + rdoどちらともいえない[iCnt].Size.Width + 5,
					rdoどちらともいえない[iCnt].Location.Y);
				rdoいいえ[iCnt].Size = new Size(
					90,
					rdoはい[iCnt].Size.Height);
				rdoいいえ[iCnt].AutoSize = false;
				rdoいいえ[iCnt].Name = "rdoいいえ" + iCnt.ToString();
				rdoいいえ[iCnt].TabIndex = 3;
				rdoいいえ[iCnt].TabStop = true;
				rdoいいえ[iCnt].Text = "いいえ";
				rdoいいえ[iCnt].UseVisualStyleBackColor = true;
				rdoいいえ[iCnt].Font = new Font("MS UI Gothic", 12F, FontStyle.Regular, GraphicsUnit.Point, ((byte)(128)));

				pnl回答[iCnt].Controls.Add(rdo訂正回答[iCnt]);
				rdo訂正回答[iCnt].Location = new Point(
					rdoはい[iCnt].Location.X,
					rdoはい[iCnt].Location.Y + rdoはい[iCnt].Size.Height);
				rdo訂正回答[iCnt].Size = new Size(
					90,
					rdoはい[iCnt].Size.Height);
				rdo訂正回答[iCnt].AutoSize = false;
				rdo訂正回答[iCnt].Name = "rdo訂正回答" + iCnt.ToString();
				rdo訂正回答[iCnt].TabIndex = 1;
				rdo訂正回答[iCnt].TabStop = true;
				rdo訂正回答[iCnt].Text = "訂正あり";
				rdo訂正回答[iCnt].UseVisualStyleBackColor = true;
				rdo訂正回答[iCnt].Font = new Font("MS UI Gothic", 12F, FontStyle.Regular, GraphicsUnit.Point, ((byte)(128)));

				pnl回答[iCnt].Controls.Add(rdo未回答[iCnt]);
				rdo未回答[iCnt].Location = new Point(
					rdo訂正回答[iCnt].Location.X + rdo訂正回答[iCnt].Size.Width + 5,
					rdo訂正回答[iCnt].Location.Y);
				rdo未回答[iCnt].Size = new Size(
					80,
					rdoはい[iCnt].Size.Height);
				rdo未回答[iCnt].Name = "rdo未回答" + iCnt.ToString();
				rdo未回答[iCnt].AutoSize = false;
				rdo未回答[iCnt].TabIndex = 1;
				rdo未回答[iCnt].TabStop = true;
				rdo未回答[iCnt].Text = "未回答";
				rdo未回答[iCnt].UseVisualStyleBackColor = true;
				rdo未回答[iCnt].Font = new Font("MS UI Gothic", 12F, FontStyle.Regular, GraphicsUnit.Point, ((byte)(128)));

				pnl回答[iCnt].ResumeLayout(false);
				pnl回答[iCnt].PerformLayout();
			}
		}

		private void Bind回答入力()
		{
			pnl回答Top.SuspendLayout();
			pnl回答Top.Controls.Add(shapeContainer2);
			for (byte iCnt = 0; iCnt < 120; iCnt++)
			{
				pnl回答Top.Controls.Add(lbl設問No[iCnt]);
				pnl回答Top.Controls.Add(txt設問[iCnt]);
				pnl回答Top.Controls.Add(pnl回答[iCnt]);
			}

			pnl回答Top.ResumeLayout(false);
			pnl回答Top.PerformLayout();
		}

		private static bool データ展開(out string str性別)
		{
			str性別 = "";

			string strデータ;
			if (C04システム共通処理.ReadFile_TSV(out strデータ) == false)
				return false;

			strデータ = strデータ.Replace("\r\n", "\n");
			string[] str = strデータ.Split('\n');
			str性別 = str[0];

			string[] str回答 = str[1].Split('\t');

			for (byte iCnt = 0; iCnt < 120; iCnt++)
			{
				if (0 <= str回答[iCnt].IndexOf("はい"))
					rdoはい[iCnt].Checked = true;
				else if (0 <= str回答[iCnt].IndexOf("どちらともいえない"))
					rdoどちらともいえない[iCnt].Checked = true;
				else if (0 <= str回答[iCnt].IndexOf("いいえ"))
					rdoいいえ[iCnt].Checked = true;
				else if (0 <= str回答[iCnt].IndexOf("訂正あり"))
					rdo訂正回答[iCnt].Checked = true;
				else
					rdo未回答[iCnt].Checked = true;
			}

			return true;
		}

		private bool データ展開_テキスト入力(string[] stra回答)
		{
			if (0 <= stra回答[0].IndexOf("男性"))
				rdo男性.Checked = true;
			else
				rdo女性.Checked = true;

			for (byte iCnt = 1; iCnt < 121; iCnt++)
			{
				if (0 <= stra回答[iCnt].IndexOf("はい"))
					rdoはい[iCnt - 1].Checked = true;
				else if (0 <= stra回答[iCnt].IndexOf("どちらともいえない"))
					rdoどちらともいえない[iCnt - 1].Checked = true;
				else if (0 <= stra回答[iCnt].IndexOf("いいえ"))
					rdoいいえ[iCnt - 1].Checked = true;
				else if (0 <= stra回答[iCnt].IndexOf("訂正あり"))
					rdo訂正回答[iCnt - 1].Checked = true;
				else
					rdo未回答[iCnt - 1].Checked = true;
			}

			return true;
		}


		#endregion


		////////////////////////////////////////////////////////////////////////
		// 非公開 イベントハンドラ
		////////////////////////////////////////////////////////////////////////
		#region 非公開 イベントハンドラ

		private void F03回答入力_Load(object sender, EventArgs e)
		{
            try
            {
				Create回答入力();
				Bind回答入力();
				設問に内容を表示();
			}
			catch (Exception ex)
			{
				C04システム共通処理.ErrorLog("F03回答入力", "F03回答入力_Load", ex);
			}
		}

		private void btn回答内容をテキスト入力する_Click(object sender, EventArgs e)
		{
			try
			{
				F05回答テキスト入力 f = new F05回答テキスト入力();
				//f.mstr回答 = str診断結果;
				f.ShowDialog();

				データ展開_テキスト入力(f.mstra回答);

				MessageBox.Show("完了しました。", "回答入力", MessageBoxButtons.OK,
					MessageBoxIcon.Information);
			}
			catch (Exception ex)
			{
				C04システム共通処理.ErrorLog("F03回答入力", "btn回答内容をテキスト入力する_Click", ex);
			}
		}

		private void btn回答内容をファイルから読込む_Click(object sender, EventArgs e)
		{
            try
            {
				string str性別;
				if (データ展開(out str性別) == false)
					return;

				if (0 <= str性別.IndexOf("男性"))
					rdo男性.Checked = true;
				else
					rdo女性.Checked = true;

				MessageBox.Show("完了しました。", "ファイル読込", MessageBoxButtons.OK,
					MessageBoxIcon.Information);
			}
			catch (Exception ex)
			{
				C04システム共通処理.ErrorLog("F03回答入力", "btn回答内容をファイルから読込む_Click", ex);
			}
		}


		private void btn回答データ診断_Click(object sender, EventArgs e)
		{
            try
            {
				if (入力チェック() == false)
					return;

				string str性別;
				string str回答;
				回答生成(out str性別, out str回答);

				string str診断結果;
				string strエラー;
				CharacterDiagnosis.Diagnosis(str性別, str回答, out str診断結果, out strエラー);

				if (strエラー.Length > 0)
				{
					MessageBox.Show("エラーが発生しました\r\n\r\n" + strエラー
						, "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
					return;
				}

				Result r = new Result();
				r.mstr結果 = str診断結果;
				r.ShowDialog();
			}
			catch (Exception ex)
			{
				C04システム共通処理.ErrorLog("F03回答入力", "btn回答データ診断_Click", ex);
			}
		}

		private void btn回答内容をファイルに保存する_Click(object sender, EventArgs e)
		{
            try
            {
				if (入力チェック() == false)
					return;

				string str性別;
				string str回答;
				回答生成(out str性別, out str回答);

				C04システム共通処理.SaveFile_TSV(str性別 + "\r\n" + str回答);

				//Result r = new Result();
				//r.mstr結果 = str回答;
				//r.ShowDialog();
			}
			catch (Exception ex)
			{
				C04システム共通処理.ErrorLog("F03回答入力", "btn回答内容をファイルに保存する_Click", ex);
			}
		}


		private void btn閉じる_Click(object sender, EventArgs e)
		{
			try
			{
				this.Close();
			}
			catch (Exception ex)
			{
				C04システム共通処理.ErrorLog("F03回答入力", "btn閉じる_Click", ex);
			}
		}

		#endregion



	}
}
