﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using SystemCommon;

namespace 最妙性格診断
{
	public partial class F05回答テキスト入力 : Form
	{
		////////////////////////////////////////////////////////////////////////
		// メンバ変数
		////////////////////////////////////////////////////////////////////////
		#region メンバ変数

		public string mstr回答;
		public string[] mstra回答;

		#endregion


		////////////////////////////////////////////////////////////////////////
		// 共通メソッド 
		////////////////////////////////////////////////////////////////////////
		#region 公開 共通メソッド

		public F05回答テキスト入力()
		{
			InitializeComponent();
		}

		#endregion


		////////////////////////////////////////////////////////////////////////
		// 非公開 共通メソッド
		////////////////////////////////////////////////////////////////////////
		#region 非公開 共通メソッド

		private bool 入力チェック(string[] straデータ)
		{

			if (121 > straデータ.Length)
			{
				MessageBox.Show("性別と120設問の回答を合わせた、121行分のデータが入力されていません。"
					, "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
				return false;
			}

			if (straデータ[0] != "男性" &&
				straデータ[0] != "女性")
			{
				MessageBox.Show("1行目に性別以外が入力されています。\r\n1行目の性別に入力できるのは、「男性」「女性」のいずれかです。"
					, "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
				return false;
			}

			for (byte iCnt = 1; iCnt < 121; iCnt++)
			{
				if (straデータ[iCnt] != "はい" &&
					straデータ[iCnt] != "どちらともいえない" &&
					straデータ[iCnt] != "いいえ" &&
					straデータ[iCnt] != "訂正あり" &&
					straデータ[iCnt] != "未回答")
				{
					MessageBox.Show((iCnt + 1).ToString() + "行目に回答の選択肢ではない値が入力されています。\r\n2行目から121行目までの回答に入力できるのは、「はい」「どちらともいえない」「いいえ」「訂正あり」「未回答」のいずれかです。"
							, "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
					return false;
				}
			}

			return true;
		}

		#endregion


		////////////////////////////////////////////////////////////////////////
		// 非公開 イベントハンドラ
		////////////////////////////////////////////////////////////////////////
		#region 非公開 イベントハンドラ

		private void btn入力_Click(object sender, EventArgs e)
		{
			try
			{
				string strデータ;
				strデータ = txt回答.Text;

				strデータ = strデータ.Replace("\r\n", "\n");
				mstra回答 = strデータ.Split('\n');

				if (入力チェック(mstra回答) == false)
					return;

				mstr回答 = strデータ;

				this.Close();
			}
			catch (Exception ex)
			{
				C04システム共通処理.ErrorLog("F05回答テキスト入力", "btn閉じる_Click", ex);
			}
		}

		private void btn閉じる_Click(object sender, EventArgs e)
		{
			try
			{
				this.Close();
			}
			catch (Exception ex)
			{
				C04システム共通処理.ErrorLog("F05回答テキスト入力", "btn閉じる_Click", ex);
			}
		}

		#endregion
	}
}
