//-----------------------------------------------------------------------
//  This file is part of the Microsoft Robotics Studio Code Samples.
// 
//  Copyright (C) Microsoft Corporation.  All rights reserved.
//
//  $File: SickLRFTypes.cs $ $Revision: 1 $
//-----------------------------------------------------------------------

using System;


using Microsoft.Ccr.Core;
using Microsoft.Dss.Core.Attributes;
using Microsoft.Dss.ServiceModel.Dssp;
using sicklrf=Microsoft.Robotics.Services.Sensors.SickLRF;
using Microsoft.Dss.Core.DsspHttp;
using System.ComponentModel;

namespace Microsoft.Robotics.Services.Sensors.SickLRF
{
    /// <summary>
    /// Contract type
    /// </summary>
    public static class Contract
    {
        /// <summary>
        /// SickLRF service namespace
        /// </summary>
        public const string Identifier = "http://schemas.microsoft.com/xw/2005/12/sicklrf.html";
    }

    /// <summary>
    /// Main service port type
    /// </summary>
    class SickLRFOperations
        : PortSet<
            DsspDefaultLookup,
            DsspDefaultDrop,
            Get,
            Replace,
            ReliableSubscribe,
            Subscribe,
            Reset,
            HttpGet>
    {
    }

    /// <summary>
    /// Get message.
    /// Send this message to the SickLRF service port to get the state of the service.
    /// </summary>
    [Description("Gets the current state of the laser range finder.")]
    class Get : Get<GetRequestType, DsspResponsePort<State>>{}

    /// <summary>
    /// Replace message.
    /// Send this message to the SickLRF service port to replace the state of the service.
    /// </summary>
    [DisplayName ("Measurement")]
    [Description("Indicates when the laser range finder reports a new measurement.")]
    class Replace : Replace<State, DsspResponsePort<DefaultReplaceResponseType>> {}

    /// <summary>
    /// Subscribe message.
    /// Send this message to the SickLRF service port to subscribe to the SickLRF service.
    /// </summary>
    class Subscribe : Subscribe<SubscribeRequestType, DsspResponsePort<SubscribeResponseType>, SickLRFOperations> {}

    class ReliableSubscribe : Subscribe<ReliableSubscribeRequestType, DsspResponsePort<SubscribeResponseType>, SickLRFOperations> { }

    [Description("Resets the laser range finder.")]
    class Reset : Submit<ResetType, DsspResponsePort<DefaultSubmitResponseType>>
    {
    }

    [DataContract]
    public class ResetType
    {
    }
}