﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Robotics.ReplaceEX
{
    class URG
    {
        public delegate void DataRecievedHandler(string data);
        public event DataRecievedHandler Recieved; //センサから返信を受けたら発生するRecievedイベントハンドラ

        private System.IO.Ports.SerialPort serialPort1 = new System.IO.Ports.SerialPort();//シリアルポートの追加

        public void portOpen(string portNo)
        {
            this.serialPort1.DataReceived += new System.IO.Ports.SerialDataReceivedEventHandler(serialPort1_DataReceived);//シリアル通信から受信したときのイベントハンドラ
            this.serialPort1.PortName = portNo;
            this.serialPort1.BaudRate = 19200;
            this.serialPort1.Parity = System.IO.Ports.Parity.None;
            this.serialPort1.DataBits = 8;
            this.serialPort1.StopBits = System.IO.Ports.StopBits.One;
            this.serialPort1.Open();
            this.sendCmd("SCIP2.0\n");//起動モードをSCIP1.0から2.0に変更．これがないと，返り値が「E」とだけ出て動かない．
        }
        public void portClose()
        {
            this.serialPort1.Close();
        }

        public void sendCmd(String cmd)
        {
            this.serialPort1.WriteLine(cmd);
        }


        private void serialPort1_DataReceived(object sender, System.IO.Ports.SerialDataReceivedEventArgs e)//シリアル通信に受信があると呼ばれるメソッド
        {
            string receivedData;

            try
            {
                receivedData = this.Decode(this.serialPort1.ReadExisting());//シリアルポートから受信内容を取り出す

            }
            catch (Exception ex)
            {
                receivedData = ex.Message;
            }

            notify(receivedData);

        }

        protected virtual void notify(string message)//ポートからセンサの返信を受け取ったことを示すRecievedイベントを発行するメソッド
        {
            if (Recieved != null)
            {
                Recieved(message);
            }

        }

        private string Decode(string receivedData)
        {
            string[] delimiter = {this.serialPort1.NewLine}; 
            string[] parts = receivedData.Split(delimiter, StringSplitOptions.RemoveEmptyEntries);
            string   d = String.Empty;
            string   r = String.Empty;

            if (parts.Length > 3)
            {
                for (int i = 3; i < parts.Length; i++)
                {
                    parts[i] = parts[i].Remove(parts[i].Length-1,1);
                    r += parts[i];

                }
                //r = r.Remove(r.Length-1, 1);

                //int ch = 44;
                for (int k = 0; k < r.Length; k += 3)
                {
                    string s = String.Empty;

                    int x = r[k] - 0x30;
                    string t = Convert.ToString(x, 2);
                    s += t.PadLeft(6, '0');

                    x = r[k + 1] - 0x30;
                    t = Convert.ToString(x, 2);
                    s += t.PadLeft(6, '0');
                    
                    x = r[k + 2] - 0x30;
                    t = Convert.ToString(x, 2);
                    s += t.PadLeft(6, '0');

                    x = Convert.ToInt32(s, 2); //
                    if (x < 19)                //距離データが19以下ならエラーとして0に
                        x = 0;                 //
                    
                    //d += "[" + ch++ + "]";     //デコードテスト用，ステップ番号添付
                    d += x + "\r";
                }

                //string[] dsitance = d.Split(delimiter, StringSplitOptions.RemoveEmptyEntries);

                return d;
            }
            else
            {
                return receivedData;
            }


        }
    
    }
}
