package jp.sourceforge.reedsolomon;

/**
 * BCH(15, 5) Encoder/Decoder
 *
 * @author Masayuki Miyazaki
 * http://sourceforge.jp/projects/reedsolomon/
 */
public final class BCH_15_5 {
	private static final int GX = 0x137;
	private static final BCH_15_5 instance = new BCH_15_5();
	private int[] trueCodes = new int[32];

	private BCH_15_5() {
		makeTrueCodes();
	}

	public static BCH_15_5 getInstance() {
		return instance;
	}

	private void makeTrueCodes() {
		for(int i = 0; i < trueCodes.length; i++) {
			trueCodes[i] = slowEncode(i);
		}
	}

	private int slowEncode(int data) {
		int wk = 0;
		data <<= 5;
		for(int i = 0; i < 5; i++) {
			wk <<= 1;
			data <<= 1;
			if(((wk ^ data) & 0x400) != 0) {
				wk ^= GX;
			}
		}
		return (data & 0x7c00) | (wk & 0x3ff);
	}

	public int encode(int data) {
		return trueCodes[data & 0x1f];
	}

	private static int calcDistance(int c1, int c2) {
		int n = 0;
		int wk = c1 ^ c2;
		while(wk != 0) {
			if((wk & 1) != 0) {
				n++;
			}
			wk >>= 1;
		}
		return n;
	}

	/**
	 * BCH(15, 5) Decoder
	 *
	 * @param data int
	 *		input data
	 * @return int
	 *		-1 : fail
	 *		>= 0 : corrected data
	 */
	public int decode(int data) {
		data &= 0x7fff;
		for(int code: trueCodes) {
			if(calcDistance(data, code) <= 3) {
				return code;
			}
		}
		return -1;
	}
}
