/*
 * Decompiled with CFR 0.152.
 */
package jtssplitter.data;

import java.util.ArrayList;
import jtssplitter.calc;
import jtssplitter.data.descriptor.ARIB_Audio_Component_Descriptor;
import jtssplitter.data.descriptor.ARIB_Video_Compornent_Descriptor;
import jtssplitter.data.descriptor.abstract_Descriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Descriptor {
    private calc cal = new calc();

    public String analyze(String s) {
        StringBuffer sb = new StringBuffer();
        int curp = 0;
        while (s.length() > curp + 16) {
            String adds = "";
            int tag = this.cal.TSString2Int(s, curp + 0, 8);
            int len = this.cal.TSString2Int(s, curp + 8, 8) * 8;
            String des_s = s.substring(curp + 16, curp + 16 + len);
            curp = curp + len + 16;
            switch (tag) {
                case 200: {
                    switch (this.cal.TSString2Int(des_s, 3, 4)) {
                        case 0: {
                            adds = "Video:1080p";
                            break;
                        }
                        case 1: {
                            adds = "Video:1080i";
                            break;
                        }
                        case 2: {
                            adds = "Video:720p";
                            break;
                        }
                        case 3: {
                            adds = "Video:480p";
                            break;
                        }
                        case 4: {
                            adds = "Video:480i";
                            break;
                        }
                        case 5: {
                            adds = "Video:240p";
                            break;
                        }
                        case 6: {
                            adds = "Video:120p";
                            break;
                        }
                        case 7: {
                            adds = "Video:2160p";
                        }
                    }
                    break;
                }
                case 196: {
                    switch (this.cal.TSString2Int(des_s, 8, 8)) {
                        case 1: {
                            adds = "Video:120p";
                        }
                    }
                }
            }
            if (adds.length() <= 0) continue;
            sb.append(adds);
        }
        return sb.toString();
    }

    public ArrayList<abstract_Descriptor> getDescriptors(String s) {
        calc cal = new calc();
        return this.getDescriptors(cal.String2Byte(s));
    }

    public ArrayList<abstract_Descriptor> getDescriptors(byte[] b) {
        int curp = 0;
        ArrayList<abstract_Descriptor> ad = new ArrayList<abstract_Descriptor>();
        while (b.length > curp + 2) {
            int tag = b[curp] & 0xFF;
            int len = b[curp + 1] & 0xFF;
            byte[] btag = new byte[len];
            System.arraycopy(b, curp + 2, btag, 0, len);
            curp = curp + len + 2;
            switch (tag) {
                case 200: {
                    ARIB_Video_Compornent_Descriptor avcd = new ARIB_Video_Compornent_Descriptor();
                    avcd.analyzeDescriptor(200, btag);
                    ad.add(avcd);
                    break;
                }
                case 196: {
                    ARIB_Audio_Component_Descriptor aacd = new ARIB_Audio_Component_Descriptor();
                    aacd.analyzeDescriptor(196, btag);
                    ad.add(aacd);
                }
            }
        }
        return ad;
    }
}

