// CasClient.cpp: CCasClient NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include "W2L.h"
#include "CasClient.h"


#define TCP_TIMEOUT		1000UL		// 1b


CCasClient::CCasClient(ICasClientHandler *pEventHandler, CSmartSock *pSocket)
	: CBcasCard()
	, m_pSocket(pSocket)
	, m_pEventHandler(pEventHandler)
	, m_hClientThread(NULL)
{
	// NCAgXbhN
	pthread_create(&m_hClientThread, NULL, CCasClient::ClientThreadRaw, (LPVOID)this);
	if(!m_hClientThread){
		printf("ClientThread failed\n");
		delete this;
	}
	printf("ClientThread started\n");
}

CCasClient::~CCasClient(void)
{
	delete m_pSocket;
	if (m_hClientThread) pthread_join(m_hClientThread, NULL);
}

void CCasClient::CloseClient(void)
{
	// NCAgؒf
	m_pSocket->Close();
}

void CCasClient::ClientThread(void)
{
	// J[h[_J
	if(!OpenCard())return;
	
	// Mobt@
	BYTE byDataLen;
	BYTE RecvBuf[256];
	DWORD dwRecvSize;
	
	// bZ[WM[v
	while(1){
		// wb_M
		if(!m_pSocket->Recv(&byDataLen, 1UL, TCP_TIMEOUT)){
			if(m_pSocket->GetLastError() == CSmartSock::EC_TIMEOUT)continue;
			else break;
		}

		// f[^M
		if(!m_pSocket->Recv(RecvBuf, byDataLen, TCP_TIMEOUT))break;
	
		// J[hM
		if(!TransmitCommand(RecvBuf, byDataLen, &RecvBuf[1], sizeof(RecvBuf) - 1UL, &dwRecvSize))dwRecvSize = 0UL;

		// f[^𑗐M
		RecvBuf[0] = (BYTE)dwRecvSize;
		if(!m_pSocket->Send(RecvBuf, dwRecvSize + 1UL, TCP_TIMEOUT))break;
	}

	printf("ClientThread exited\n");
	// J[h[_
	CloseCard();
}

void* CCasClient::ClientThreadRaw(LPVOID pParam)
{
	// NCAgXbh
	CCasClient *pThis = static_cast<CCasClient *>(pParam);

	// ڑCxgʒm
	pThis->SendEvent(EID_CONNECTED);

	// o֐Ƀ_CNg
	pThis->ClientThread();

	// ؒfCxgʒm
	pThis->SendEvent(EID_DISCONNECTED);

	delete pThis;

	return 0UL;
}

void CCasClient::SendEvent(const DWORD dwEventID, PVOID pParam)
{
	// nhɃCxgʒm
	if(m_pEventHandler)m_pEventHandler->OnCasClientEvent(this, dwEventID, pParam);
}
