// TsDescriptor.h: Lqqbp[NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "TsEncode.h"
#include "TsDescriptor.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


/////////////////////////////////////////////////////////////////////////////
// Lqq̊NX
/////////////////////////////////////////////////////////////////////////////

CBaseDesc::CBaseDesc()
{
	Reset();
}

CBaseDesc::CBaseDesc(const CBaseDesc &Operand)
{
	// Rs[RXgN^
	*this = Operand;
}

CBaseDesc::~CBaseDesc()
{

}

CBaseDesc & CBaseDesc::operator = (const CBaseDesc &Operand)
{
	// Zq
	CopyDesc(&Operand);

	return *this;
}

void CBaseDesc::CopyDesc(const CBaseDesc *pOperand)
{
	// CX^X̃Rs[
	m_byDescTag = pOperand->m_byDescTag;
	m_byDescLen = pOperand->m_byDescLen;
	m_bIsValid = pOperand->m_bIsValid;
}

const bool CBaseDesc::ParseDesc(const BYTE *pHexData, const WORD wDataLength)
{
	Reset();
	
	// ʃtH[}bg`FbN
	if(!pHexData)return false;										// f[^
	else if(wDataLength < 2U)return false;							// f[^ŒLqqTCY
	else if(wDataLength < (WORD)(pHexData[1] + 2U))return false;	// f[^Lqq̃TCY

	m_byDescTag = pHexData[0];
	m_byDescLen = pHexData[1];

	// yC[h
	if(StoreContents(&pHexData[2])){
		m_bIsValid = true;
		}
	
	return m_bIsValid;
}

const bool CBaseDesc::IsValid(void) const
{
	// f[^L(͍)ǂԂ
	return m_bIsValid;
}

const BYTE CBaseDesc::GetTag(void) const
{
	// Lqq^OԂ
	return m_byDescTag;
}

const BYTE CBaseDesc::GetLength(void) const
{
	// LqqԂ
	return m_byDescLen;
}

void CBaseDesc::Reset(void)
{
	// ԂNA
	m_byDescTag = 0x00U;
	m_byDescLen = 0U;
	m_bIsValid = false;
}

const bool CBaseDesc::StoreContents(const BYTE *pPayload)
{
	// ftHg̎ł͉Ȃ
	return true;
}


/////////////////////////////////////////////////////////////////////////////
// [0x09] Conditional Access LqqۉNX
/////////////////////////////////////////////////////////////////////////////

CCaMethodDesc::CCaMethodDesc()
	: CBaseDesc()
{
	Reset();
}

CCaMethodDesc::CCaMethodDesc(const CCaMethodDesc &Operand)
{
	*this = Operand;
}

CCaMethodDesc & CCaMethodDesc::operator = (const CCaMethodDesc &Operand)
{
	CopyDesc(&Operand);

	return *this;
}

void CCaMethodDesc::CopyDesc(const CBaseDesc *pOperand)
{
	// CX^X̃Rs[
	CBaseDesc::CopyDesc(pOperand);

	const CCaMethodDesc *pSrcDesc = dynamic_cast<const CCaMethodDesc *>(pOperand);
	
	if(pSrcDesc){
		m_wCaMethodID = pSrcDesc->m_wCaMethodID;
		m_wCaPID = pSrcDesc->m_wCaPID;
		m_PrivateData = pSrcDesc->m_PrivateData;
		}
}

void CCaMethodDesc::Reset(void)
{
	CBaseDesc::Reset();

	m_wCaMethodID = 0x0000U;		// Conditional Access Method ID
	m_wCaPID = 0xFFFFU;				// Conditional Access PID
	m_PrivateData.ClearSize();		// Private Data
}

const WORD CCaMethodDesc::GetCaMethodID(void) const
{
	// Conditional Access Method ID Ԃ
	return m_wCaMethodID;
}

const WORD CCaMethodDesc::GetCaPID(void) const
{
	// Conditional Access PID
	return m_wCaPID;
}

const CMediaData * CCaMethodDesc::GetPrivateData(void) const
{
	// Private Data Ԃ
	return &m_PrivateData;
}

const bool CCaMethodDesc::StoreContents(const BYTE *pPayload)
{
	// tH[}bg`FbN
	if(m_byDescTag != 0x09U)return false;								// ^Os
	else if(m_byDescLen < 4U)return false;								// CA\bhLqq̍ŏTCY4
	else if((pPayload[2] & 0xE0U) != 0xE0U)return false;				// Œrbgs

	// Lqq
	m_wCaMethodID = (WORD)pPayload[0] << 8 | (WORD)pPayload[1];			// +0,1	Conditional Access Method ID
	m_wCaPID = (WORD)(pPayload[2] & 0x1FU) << 8 | (WORD)pPayload[3];	// +2,3	Conditional Access PID
	m_PrivateData.SetData(&pPayload[4], m_byDescLen - 4U);				// +4-	Private Data

	return true;
}


/////////////////////////////////////////////////////////////////////////////
// [0x48] Service LqqۉNX
/////////////////////////////////////////////////////////////////////////////

CServiceDesc::CServiceDesc()
	: CBaseDesc()
{
	Reset();
}

CServiceDesc::CServiceDesc(const CServiceDesc &Operand)
{
	*this = Operand;
}

CServiceDesc & CServiceDesc::operator = (const CServiceDesc &Operand)
{
	CopyDesc(&Operand);
	
	return *this;
}

void CServiceDesc::CopyDesc(const CBaseDesc *pOperand)
{
	// CX^X̃Rs[
	CBaseDesc::CopyDesc(pOperand);

	const CServiceDesc *pSrcDesc = dynamic_cast<const CServiceDesc *>(pOperand);
	
	if(pSrcDesc){
		m_byServiceType = pSrcDesc->m_byServiceType;
		::lstrcpy(m_szProviderName, pSrcDesc->m_szProviderName);
		::lstrcpy(m_szServiceName, pSrcDesc->m_szServiceName);
		}
}

void CServiceDesc::Reset(void)
{
	CBaseDesc::Reset();
	
	m_byServiceType = 0x00U;			// Service Type
	m_szProviderName[0] = TEXT('\0');	// Service Provider Name
	m_szServiceName[0] = TEXT('\0');	// Service Name
}

const BYTE CServiceDesc::GetServiceType(void) const
{
	// Service TypeԂ
	return m_byServiceType;
}

const DWORD CServiceDesc::GetProviderName(LPTSTR lpszDst) const
{
	// Service Provider NameԂ
	if(lpszDst)::lstrcpy(lpszDst, m_szProviderName);

	return ::lstrlen(m_szProviderName);
}

const DWORD CServiceDesc::GetServiceName(LPTSTR lpszDst) const
{
	// Service Provider NameԂ
	if(lpszDst)::lstrcpy(lpszDst, m_szServiceName);

	return ::lstrlen(m_szServiceName);
}

const bool CServiceDesc::StoreContents(const BYTE *pPayload)
{
	// tH[}bg`FbN
	if(m_byDescTag != 0x48U)return false;		// ^Os
	else if(m_byDescLen < 3U)return false;		// T[rXLqq̃TCY͍Œ3

	// Lqq
	m_byServiceType = pPayload[0];				// +0	Service Type
	
	BYTE byPos = 1U;
	
	// Provider Name
	if(pPayload[byPos + 0]){
		CAribString::AribToString(m_szProviderName, &pPayload[byPos + 1], pPayload[byPos + 0]);
		byPos += pPayload[byPos + 0];
		}
	
	byPos++;

	// Service Name
	if(pPayload[byPos + 0]){
		CAribString::AribToString(m_szServiceName, &pPayload[byPos + 1], pPayload[byPos + 0]);
		byPos += pPayload[byPos + 0];
		}

	return true;
}


/////////////////////////////////////////////////////////////////////////////
// [0x52] Stream Identifier LqqۉNX
/////////////////////////////////////////////////////////////////////////////

CStreamIdDesc::CStreamIdDesc()
	: CBaseDesc()
{
	Reset();
}

CStreamIdDesc::CStreamIdDesc(const CStreamIdDesc &Operand)
{
	*this = Operand;
}

CStreamIdDesc & CStreamIdDesc::operator = (const CStreamIdDesc &Operand)
{
	CopyDesc(&Operand);

	return *this;
}

void CStreamIdDesc::CopyDesc(const CBaseDesc *pOperand)
{
	// CX^X̃Rs[
	CBaseDesc::CopyDesc(pOperand);

	const CStreamIdDesc *pSrcDesc = dynamic_cast<const CStreamIdDesc *>(pOperand);
	
	if(pSrcDesc){
		m_byComponentTag = pSrcDesc->m_byComponentTag;
		}
}

void CStreamIdDesc::Reset(void)
{
	CBaseDesc::Reset();

	m_byComponentTag = 0x00U;	// Component Tag
}

const BYTE CStreamIdDesc::GetComponentTag(void) const
{
	// Component Tag Ԃ
	return m_byComponentTag;
}

const bool CStreamIdDesc::StoreContents(const BYTE *pPayload)
{
	// tH[}bg`FbN
	if(m_byDescTag != 0x52U)return false;		// ^Os
	else if(m_byDescLen != 1U)return false;		// Xg[IDLqq̃TCY͏1

	// Lqq
	m_byComponentTag = pPayload[0];				// +0	Component Tag

	return true;
}


/////////////////////////////////////////////////////////////////////////////
// LqqubNۉNX
/////////////////////////////////////////////////////////////////////////////

CDescBlock::CDescBlock()
{

}

CDescBlock::CDescBlock(const CDescBlock &Operand)
{
	*this = Operand;
}

CDescBlock::~CDescBlock()
{
	Reset();
}

CDescBlock & CDescBlock::operator = (const CDescBlock &Operand)
{
	// CX^X̃Rs[
	Reset();
	m_DescArray.resize(Operand.m_DescArray.size());
	
	for(WORD wIndex = 0UL ; wIndex < m_DescArray.size() ; wIndex++){
		m_DescArray[wIndex] = CreateDescInstance(Operand.m_DescArray[wIndex]->GetTag());
		m_DescArray[wIndex]->CopyDesc(Operand.m_DescArray[wIndex]);
		}
	
	return *this;
}

const WORD CDescBlock::ParseBlock(const BYTE *pHexData, const WORD wDataLength)
{
	if(!pHexData || (wDataLength < 2U))return 0U;

	// ԂNA
	Reset();

	// w肳ꂽubNɊ܂܂Lqq͂
	WORD wPos = 0UL;
	CBaseDesc *pNewDesc = NULL;
	
	while(wPos < wDataLength){
		// ubN͂
		if(!(pNewDesc = ParseDesc(&pHexData[wPos], wDataLength - wPos)))break;

		// Xgɒǉ
		m_DescArray.push_back(pNewDesc);

		// ʒuXV
		wPos += (pNewDesc->GetLength() + 2U);
		}

	return m_DescArray.size();
}

const CBaseDesc * CDescBlock::ParseBlock(const BYTE *pHexData, const WORD wDataLength, const BYTE byTag)
{
	// w肳ꂽubNɊ܂܂Lqq͂Ďw肳ꂽ^ŐLqqԂ
	return (ParseBlock(pHexData, wDataLength))? GetDescByTag(byTag) : NULL;
}

void CDescBlock::Reset(void)
{
	// SẴCX^XJ
	for(WORD wIndex = 0U ; wIndex < m_DescArray.size() ; wIndex++){
		delete m_DescArray[wIndex];
		}
		
	m_DescArray.clear();
}

const WORD CDescBlock::GetDescNum(void) const
{
	// Lqq̐Ԃ
	return m_DescArray.size();
}

const CBaseDesc * CDescBlock::GetDescByIndex(const WORD wIndex) const
{
	// CfbNXŎw肵LqqԂ
	return (wIndex < m_DescArray.size())? m_DescArray[wIndex] : NULL;
}

const CBaseDesc * CDescBlock::GetDescByTag(const BYTE byTag) const
{
	// w肵^OɈvLqqԂ
	for(WORD wIndex = 0U ; wIndex < m_DescArray.size() ; wIndex++){
		if(m_DescArray[wIndex]->GetTag() == byTag)return m_DescArray[wIndex];
		}

	return NULL;
}

CBaseDesc * CDescBlock::ParseDesc(const BYTE *pHexData, const WORD wDataLength)
{
	if(!pHexData || (wDataLength < 2U))return NULL;

	// ^OɑΉCX^X𐶐
	CBaseDesc *pNewDesc = CreateDescInstance(pHexData[0]);

	// s
	if(!pNewDesc)return NULL;

	// Lqq͂
	if(!pNewDesc->ParseDesc(pHexData, wDataLength)){
		// G[
		delete pNewDesc;
		return NULL;
		}

	return pNewDesc;
}

CBaseDesc * CDescBlock::CreateDescInstance(const BYTE byTag)
{
	// ^OɑΉCX^X𐶐
	switch(byTag){
		case CCaMethodDesc::DESC_TAG	: return new CCaMethodDesc;
		case CServiceDesc::DESC_TAG		: return new CServiceDesc;
		case CStreamIdDesc::DESC_TAG	: return new CStreamIdDesc;
		default							: return new CBaseDesc;
		}
}
