varying vec3 v_position;
varying vec3 v_normal;
varying vec4 v_shadow_pos;

uniform mat4 shadow_mat;


void main(void)
{
	v_position = vec3(gl_ModelViewMatrix * gl_Vertex);
	v_normal   = normalize(gl_NormalMatrix * gl_Normal);

	v_shadow_pos = shadow_mat * gl_Vertex;

	gl_TexCoord[0] = gl_TextureMatrix[0] * gl_MultiTexCoord0;

	gl_Position = ftransform();

	gl_FrontColor = gl_Color;

	gl_ClipVertex = gl_ModelViewMatrix * gl_Vertex;
}
