#include "stdafx.h"
#include "PostprocInterface.h"


void PostprocInterface::SetStandardSiinglePathPPTextureConfig(lib_gl::GlslProgram& shader)
{
	PostProcBuffer& buf = m_Context->m_Buffer->GetBuf(0);

	glActiveTexture(GL_TEXTURE1);
	buf.m_ColorBuf.Bind();
	glUniform1i(shader.GetUniformLocation("tex_color"), 1);

	glActiveTexture(GL_TEXTURE2);
	buf.m_DepthBuf.Bind();
	glUniform1i(shader.GetUniformLocation("tex_depth"), 2);

	glUniform1i(shader.GetUniformLocation("tex_width"), m_Context->m_Width);
	glUniform1i(shader.GetUniformLocation("tex_height"), m_Context->m_Height);

	glUniform1f(shader.GetUniformLocation("look_depth"), m_Context->m_LookDepth);

	glActiveTexture(GL_TEXTURE0);
}
