#pragma once


template<typename T>
class NamedValue
{
public:
	NamedValue() {}
	NamedValue(const T& val, const char* name) : value(val) , name(name) {}

	void Reset(const T& val, const char* n)
	{
		value = val;
		name = n;
	}

	T* operator&(void)
	{
		return &value;
	}

	const T* operator&(void) const
	{
		return & value;
	}

	operator T&(void)
	{
		return value;
	}

	operator const T&(void) const
	{
		return value;
	}

	const char* GetName(void) const
	{
		return name.c_str();
	}

	const NamedValue<T>& operator=(const T& val)
	{
		value = val;
		return (*this);
	}

private:
	T value;
	std::string name;
};
