#pragma once

#include <C2/lm/vector3.h>

#include <LibGeo/Mesh/BaryCoord.h>

#include "NamedValue.h"



namespace geom
{

class GeomObject;

}


class Cursor3D
{
public:
	Cursor3D(void);

	void ResetCursorPos(void);
	void ResetMeasure(void);
	void ResetCloseFace(void);

	lm::vec3f GetMidMeasurePos(void) const;
	float GetMeasureLength(void) const;

	void UpdateNormal(const lm::vec3f& ep);

	bool IsHoleActive(void) const;

public:
	NamedValue<bool> ShowCursor;
	NamedValue<bool> CursorDepth;
	NamedValue<bool> ShowMeasure;
	NamedValue<bool> ShowMeasureLen;
	NamedValue<bool> ShowMeasureXYZ;
	NamedValue<bool> ShowAxis;
	NamedValue<bool> ShowCoord;
	NamedValue<bool> CheckBaryCoord;

	bool MakeHole;
	float HoleRangeRatio;

	lm::vec3f CursorPos;
	lm::vec3f MeasurePos;
	lm::vec3f MeasureNorm;

	geom::GeomObject* CloseFaceObject;
	lib_geo::BaryCoord CloseFace;
};
