import sys
import os
from VersionDef import *



def getMajorVersion():
	return MAJOR_VERSION

def getMinorVersion():
	return MINOR_VERSION


def getEnv(name):
	val = os.environ.get(name)
	if val is None:
		return '?'

	return val

def getSvnRevision():
	return getEnv('SVN_REVISION')

def getBuildID():
	return getEnv('BUILD_ID')

def getBuildNumber():
	return getEnv('BUILD_NUMBER')

def getBuildTag():
	return getEnv('BUILD_TAG')


def getMainVersion():
	return getMajorVersion() + '.' + getMinorVersion()

def getFullVersion():
	return getMainVersion() + '.' + getBuildNumber() + '.' + getSvnRevision()

def getMainVersionC():
	return getMajorVersion() + ',' + getMinorVersion()

def getFullVersionC():
	return getMainVersionC() + ',' + getBuildNumber() + ',' + getSvnRevision()

