#include "stdafx.h"
#include "View3DConfig.h"


bool View3DConfig::operator==(const View3DConfig& config) const
{
	if ( m_DrawFace            !=  config.m_DrawFace            ) return false;
	if ( m_DrawWire            !=  config.m_DrawWire            ) return false;
	if ( m_DrawVert            !=  config.m_DrawVert            ) return false;
	if ( m_DrawPolyline        !=  config.m_DrawPolyline        ) return false;
	if ( m_DrawPolylineLen     !=  config.m_DrawPolylineLen     ) return false;
	if ( m_DrawVid             !=  config.m_DrawVid             ) return false;
	if ( m_ShowSelVertCoord    !=  config.m_ShowSelVertCoord    ) return false;
	if ( m_ShowSelVertIdx      !=  config.m_ShowSelVertIdx      ) return false;
	if ( m_DrawFid             !=  config.m_DrawFid             ) return false;
	if ( m_DrawBBox            !=  config.m_DrawBBox            ) return false;
	if ( m_DrawBBoxRange       !=  config.m_DrawBBoxRange       ) return false;
	if ( m_DrawVertNormal      !=  config.m_DrawVertNormal      ) return false;
	if ( m_ShowVidTopMost      !=  config.m_ShowVidTopMost      ) return false;
	if ( m_EnableCoverageTrans !=  config.m_EnableCoverageTrans ) return false;
	if ( m_EnableMultisample   !=  config.m_EnableMultisample   ) return false;
	if ( m_EnableWireDispList  !=  config.m_EnableWireDispList  ) return false;
	if ( m_EnableFaceVBO       !=  config.m_EnableFaceVBO       ) return false;
	if ( m_EnableWireVBO       !=  config.m_EnableWireVBO       ) return false;
	if ( m_EnableLighting      !=  config.m_EnableLighting      ) return false;
	if ( m_LightIsDirectional  !=  config.m_LightIsDirectional  ) return false;
	if ( m_EnableTexture       !=  config.m_EnableTexture       ) return false;
	if ( m_EnableFlatShade     !=  config.m_EnableFlatShade     ) return false;
	if ( m_EnableCullFace      !=  config.m_EnableCullFace      ) return false;
	if ( m_CullAngle_F         !=  config.m_CullAngle_F         ) return false;
	if ( m_UseFixMaterial      !=  config.m_UseFixMaterial      ) return false;
	if ( m_UseFixTexture       !=  config.m_UseFixTexture       ) return false;
	if ( m_IndexMaterial       !=  config.m_IndexMaterial       ) return false;
	if ( m_DoubleSideShading   !=  config.m_DoubleSideShading   ) return false;
	if ( m_DrawAxis            !=  config.m_DrawAxis            ) return false;
	if ( m_DrawMiniAxis        !=  config.m_DrawMiniAxis        ) return false;
	if ( m_DrawGround          !=  config.m_DrawGround          ) return false;
	if ( m_DrawLightPosition   !=  config.m_DrawLightPosition   ) return false;
	if ( m_DrawLookPos         !=  config.m_DrawLookPos         ) return false;
	if ( m_HighlightSelected   !=  config.m_HighlightSelected   ) return false;
	if ( m_ShaderMode          !=  config.m_ShaderMode          ) return false;
	if ( m_WireColor           !=  config.m_WireColor           ) return false;
	if ( m_ShowCloseVertInfo   !=  config.m_ShowCloseVertInfo   ) return false;
	if ( m_PickTransparent     !=  config.m_PickTransparent     ) return false;
	if ( m_PointSize           !=  config.m_PointSize           ) return false;
	if ( m_NormalLength        !=  config.m_NormalLength        ) return false;
	if ( m_IndexLineLen        !=  config.m_IndexLineLen        ) return false;
	if ( m_ShowRenderTime      !=  config.m_ShowRenderTime      ) return false;
	if ( m_DrawRenderRange     !=  config.m_DrawRenderRange     ) return false;
	if ( m_DrawCameraRecord    !=  config.m_DrawCameraRecord    ) return false;
	if ( m_DrawCameraMeasure   !=  config.m_DrawCameraMeasure   ) return false;

	return true;
}

bool View3DConfig::operator!=(const View3DConfig& config) const
{
	return !((*this) == config);
}
