#include "StdAfx.h"
#include "PhongShader.h"


void PhongShader::Initialize(int num_light)
{
	m_PhongShader.Create(true);

	m_PhongShader.BeginShader();
	m_PhongShader.SetNumLights( 2 );
	m_PhongShader.SetTextureObject( 0 );
	m_PhongShader.EndShader();
}

void PhongShader::BeginShader(void)
{
	m_PhongShader.BeginShader();
}

void PhongShader::EndShader(void)
{
	m_PhongShader.EndShader();
}

void PhongShader::SetTextureEnabled(bool enabled)
{
	m_PhongShader.SetEnableTexture( enabled );
}

void PhongShader::SetDublesideEnabled(bool enabled)
{
	m_PhongShader.SetEnableDoubleSide( enabled );
}

void PhongShader::SetLightingEnabled(bool enabled)
{
	m_PhongShader.SetEnableLighting( enabled );
}
