#include "StdAfx.h"
#include "QuadCamera.h"

using namespace gl;



Camera QuadCamera::ToDiag(const Camera& maincamera, const lib_gl::Viewport& viewport)
{
	float d = maincamera.m_Manip.GetDistanceToLookPos();
	int hw = viewport.Width / 2;
	int hh = viewport.Height / 2;

	Camera cd = maincamera;
	cd.GetViewport().SetViewport(hw, hh, hw, hh);
	return cd;
}

Camera QuadCamera::ToUp(const Camera& maincamera, const lib_gl::Viewport& viewport)
{
	float d = maincamera.m_Manip.GetDistanceToLookPos();
	int hw = viewport.Width / 2;
	int hh = viewport.Height / 2;

	Camera cu = maincamera;
	cu.m_Manip.m_EyePos = cu.m_Manip.m_ViewPos + lm::vec3f(0.0f, d, 0.0f);
	cu.m_Manip.m_Up.set(0.0f, 0.0f, -1.0f);
	cu.GetViewport().SetViewport(0, hh, hw, hh);
	cu.m_ProjMode = Camera::PROJ_ORTHO;
	return cu;
}

Camera QuadCamera::ToLeft(const Camera& maincamera, const lib_gl::Viewport& viewport)
{
	float d = maincamera.m_Manip.GetDistanceToLookPos();
	int hw = viewport.Width / 2;
	int hh = viewport.Height / 2;

	Camera cl = maincamera;
	cl.m_Manip.m_EyePos = cl.m_Manip.m_ViewPos + lm::vec3f(d, 0.0f, 0.0f);
	cl.m_Manip.m_Up.set(0.0f, 1.0f, 0.0f);
	cl.GetViewport().SetViewport(hw, 0, hw, hh);
	cl.m_ProjMode = Camera::PROJ_ORTHO;
	return cl;
}

Camera QuadCamera::ToFront(const Camera& maincamera, const lib_gl::Viewport& viewport)
{
	float d = maincamera.m_Manip.GetDistanceToLookPos();
	int hw = viewport.Width / 2;
	int hh = viewport.Height / 2;

	Camera cf = maincamera;
	cf.m_Manip.m_EyePos = cf.m_Manip.m_ViewPos + lm::vec3f(0.0f, 0.0f, d);
	cf.m_Manip.m_Up.set(0.0f, 1.0f, 0.0f);
	cf.GetViewport().SetViewport(0, 0, hw, hh);
	cf.m_ProjMode = Camera::PROJ_ORTHO;
	return cf;
}
