#include "stdafx.h"
#include "DepthOfField.h"

#include "../PathInfo.h"
#include "../ShaderUtil.h"



DepthOfFieldPostproc::DepthOfFieldPostproc(PostprocContext* context) : 
	PostprocInterface(context)
{
	QString shader_path = PathInfo::GetPostprocCodeDirPath();

	std::string p = shader_path.toLocal8Bit().data();

	std::string frag_filename = p + "DepthOfField.frag";
	std::string vert_filename = p + "DepthOfField.vert";

	ShaderUtil::InitShaderStd(m_Shader, frag_filename, vert_filename);
}

void DepthOfFieldPostproc::BeginRender(void)
{
	lib_gl::GlslProgram& shader = m_Shader;
	shader.BeginShader();

	PostProcBuffer& buf0 = m_Context->m_Buffer->GetBuf(0);
	PostProcBuffer& buf1 = m_Context->m_Buffer->GetBuf(1);

	glActiveTexture(GL_TEXTURE3);
	buf1.m_DepthBuf.Bind();
	glUniform1i(shader.GetUniformLocation("tex_depth"), 3);

	glActiveTexture(GL_TEXTURE2);
	buf1.m_ColorBuf.Bind();
	glUniform1i(shader.GetUniformLocation("tex_color1"), 2);

	glActiveTexture(GL_TEXTURE1);
	buf0.m_ColorBuf.Bind();
	glUniform1i(shader.GetUniformLocation("tex_color0"), 1);

	glUniform1i(shader.GetUniformLocation("tex_width"), buf0.GetWidth());
	glUniform1i(shader.GetUniformLocation("tex_height"), buf0.GetHeight());

	glUniform1f(shader.GetUniformLocation("look_depth"), m_Context->m_LookDepth);

	glUniform1f(m_Shader.GetUniformLocation("pint_depth"), m_Context->m_DOFPintPos);
	glUniform1f(m_Shader.GetUniformLocation("pint_range"), m_Context->m_DOFRange);

	glActiveTexture(GL_TEXTURE0);
}

void DepthOfFieldPostproc::EndRender(void)
{
	m_Shader.EndShader();
}

size_t DepthOfFieldPostproc::NumPath(void)
{
	return 2;
}

double DepthOfFieldPostproc::GetImageSizeRatio(size_t path)
{
	switch(path)
	{
	case 0 : return 1.0 / 3.0;
	case 1 : return 1.0;
	default:
		assert(false);
		return 1.0;
	}
}
