#include "stdafx.h"
#include "DepthLayerColor.h"

#include "../PathInfo.h"
#include "../ShaderUtil.h"



DepthLayerColorPostproc::DepthLayerColorPostproc(PostprocContext* context) : 
	PostprocInterface(context)
{
	QString shader_path = PathInfo::GetPostprocCodeDirPath();

	std::string p = shader_path.toLocal8Bit().data();

	std::string frag_filename = p + "DepthLayerColor.frag";
	std::string vert_filename = p + "DepthLayerColor.vert";

	ShaderUtil::InitShaderStd(m_Shader, frag_filename, vert_filename);
}

void DepthLayerColorPostproc::BeginRender(void)
{
	m_Shader.BeginShader();

	SetStandardSiinglePathPPTextureConfig(m_Shader);
}

void DepthLayerColorPostproc::EndRender(void)
{
	m_Shader.EndShader();
}
