#pragma once


namespace lib_geo
{


inline TiXmlElement* TiGetElem(TiXmlNode* n)
{
		if( n->Type() != TiXmlNode::TINYXML_ELEMENT )
			return NULL;

		return dynamic_cast<TiXmlElement*>(n);
}

#define TiForeach(TYPE,VAL_NAME,PARENT_NODE) for( TYPE* VAL_NAME = (PARENT_NODE)->FirstChild() ; VAL_NAME != NULL ; VAL_NAME = VAL_NAME->NextSibling() )

#define TiElemForeach(ELEM_NAME,PARENT_NODE) for(TiXmlElement* ELEM_NAME = (PARENT_NODE)->FirstChildElement() ; ELEM_NAME != NULL ; ELEM_NAME = ELEM_NAME->NextSiblingElement() )


inline const char* TiGetFirstChildElementAsText(TiXmlNode* n)
{
	TiXmlNode* child = n->FirstChild();
	if( child == NULL )
		return NULL;

	if( child->Type() != TiXmlNode::TINYXML_TEXT )
		return NULL;

		TiXmlText* text = dynamic_cast<TiXmlText*>(child);
		if( text == NULL )
			return NULL;

		return text->Value();
}


}
