#include "stdafx.h"

#include "Geom2d.h"

#include <C2/lm/math_util.h>


namespace lib_geo
{


//! ΐ̌𔻒肷.
//! @param[in] a0 , a1 - 1{ڂ̗̐[_
//! @param[in] b0 , b1 - 2{ڂ̗̐[_
//! @retval - 2{̐ĂꍇtrueAȊOfalseԂ.
bool Geom2d::Intersect_Segments( const vec3f& a0 , const vec3f& a1 , const vec3f& b0 , const vec3f& b1 )
{
	float m , n;
	return Intersect_Segments( a0 , a1 , b0 , b1 , m , n );
}

//! ΐ̌𔻒肷.
//! @param[in]  a0 , a1         - 1{ڂ̗̐[_
//! @param[in]  b0 , b1         - 2{ڂ̗̐[_
//! @param[out] intersect_point - ̌_. zWl͏0.
//! @retval - 2{̐ĂꍇtrueAȊOfalseԂ.
bool Geom2d::Intersect_Segments( const vec3f& a0 , const vec3f& a1 , const vec3f& b0 , const vec3f& b1 , vec3f& intersect_point )
{
	float m , n;
	if( !Intersect_Segments( a0 , a1 , b0 , b1 , m , n ) )
		return false;

	intersect_point = a0 * m + a1 * (1.0f-m);
	return true;
}

//! 2{̐̌̕ [ (1-m) * a0 + m * a1 = (1-n) * b0 + n * b1 ] , ̌𔻒肷.
//! @param[in]  a0 , a1 - 1{ڂ̗̐[_
//! @param[in]  b0 , b1 - 2{ڂ̗̐[_
//! @param[out] m  , n  - Lmn̒lԂ. ( 0Ȃa0,b0ƈv, 1Ȃa1,b1ƈv )
//! @retval - 2{̐Ăꍇtrue, ȊOfalseԂ.
bool Geom2d::Intersect_Segments( const vec3f& a0 , const vec3f& a1 , const vec3f& b0 , const vec3f& b1 , float& m , float& n )
{
	float u = a1.x * (b0.y - b1.y) + a0.x * (b1.y - b0.y) + (a0.y - a1.y) * b0.x + (a1.y - a0.y) * b1.x;
	if( u == 0.0f ) return false;

	m = -( a0.x * (b0.y - b1.y) + b1.x * (a0.y - b0.y) + (b1.y - a0.y) * b0.x ) / u;
	n =  ( a1.x * (b0.y - a0.y) + a0.x * (a1.y - b0.y) + (a0.y - a1.y) * b0.x ) / u;

	if( m < 0.0f ) return false;
	if( m > 1.0f ) return false;
	if( n < 0.0f ) return false;
	if( n > 1.0f ) return false;

	return true;
}


// Β̌
bool Geom2d::Intersect_Segment_Line( const vec3f& e0 , const vec3f& e1 , const vec3f& line_pos , const vec3f& line_dir )
{
	float m , n;
	return Intersect_Segment_Line( e0 , e1 , line_pos , line_dir , m , n );
}

bool Geom2d::Intersect_Segment_Line( const vec3f& e0 , const vec3f& e1 , const vec3f& line_pos , const vec3f& line_dir , vec3f& intersect_point )
{
	float m , n;
	if( !Intersect_Segment_Line( e0 , e1 , line_pos , line_dir , m , n ) )
		return false;

	intersect_point = e0 * m + e1 * (1.0f-m);
	return true;
}

//! Β̌
//! @param[in] seg0 , seg1 - ̗[_
//! @param[in] line_pos    - ̒ʉߓ_
//! @param[in] line_dir    - ̕
//! @param[out] m          - _ʒu\̈ʒup[^ ( _ = m * e0 + (1-m) * e1 )
//! @param[out] n          - _ʒu\̈ʒup[^ ( _ = line_pos + line_dir * n )
bool Geom2d::Intersect_Segment_Line( const vec3f& e0 , const vec3f& e1 , const vec3f& line_pos , const vec3f& line_dir , float& m , float& n )
{
	float cx = e0.x - e1.x;
	float cy = e0.y - e1.y;
	float dx = line_pos.x + e1.x;
	float dy = line_pos.y + e1.y;

	float mb = cx * line_dir.y - cy  * line_dir.x;
	if( mb == 0.0f )
		return false;

	float mu = dx * line_dir.y - dy * line_dir.x;

	m = mu / mb;
	if( m < 0.0f || 1.0f < m )
		return false;

	if( abs(line_dir.x) >= abs(line_dir.y) )
		n = ( cx * m - dx ) / line_dir.x;
	else
		n = ( cy * m - dy ) / line_dir.y;

	return true;
}


//! ~ΐ̌
//! @param[in] center , radius - ~̒SƔa
//! @param[in] e0 , e1         - ̗[_
//! @retval - ~ƐĂ񐔂Ԃ(ĂȂ0,łȂ1or2).
int Geom2d::Intersect_Circle_Segment( const vec3f& center , const float& radius , const vec3f& e0 , const vec3f& e1 )
{
	float m , n;
	return Intersect_Circle_Segment( center , radius , e0 , e1 , m , n );
}

//! ~ΐ̌. vZ̃p[^Ԃ.
//! @param[in]  center , radius - ~̒SƔa
//! @param[in]  e0 , e1         - ̗[_
//! @param[out] m , n           - ̈ʒu\p[^[ _ = (1-t) * e0 + t * e1 ]. { (retval==1) => n` | (retval==2) => m<n }
//! @retval - ~ƐĂ񐔂Ԃ(ĂȂ0,łȂ1or2).
int Geom2d::Intersect_Circle_Segment( const vec3f& center , const float& radius , const vec3f& e0 , const vec3f& e1 , float& m , float& n )
{
	vec3f A = center - e0;
	vec3f B = e1 - e0;

	float X = dot( B , B );
	float Y = dot( A , B );
	float Z = dot( A , A ) - radius * radius;

	float sqrt_part = Y * Y - Z * X;
	if( sqrt_part < 0.0f ) return 0;

	if( sqrt_part == 0.0f )
	{
		m = Y / X;
		if( m < 0.0f || 1.0f < m ) return 0;
		return 1;
	}
	else
	{
		sqrt_part = sqrt( sqrt_part );

		m = ( Y - sqrt_part ) / X;
		n = ( Y + sqrt_part ) / Y;

		if( m < 0.0f || 1.0f < m )
		{
			(std::swap)( m , n );
		}

		if( m < 0.0f || 1.0f < m ) return 0;
		if( n < 0.0f || 1.0f < n ) return 1;
		return 2;
	}
}

//! AABBΐ̌
//! @param[in] e0 , e1 - ̎n_ƏI_
//! @retval true - Ăꍇ , false - ĂȂꍇ
bool Geom2d::Intersect_AABB_Segment( const range3f& aabb , const vec3f& e0 , const vec3f& e1 )
{
	float t_top_max = -(std::numeric_limits<float>::max)();
	float t_end_min =  (std::numeric_limits<float>::max)();

	vec3f v10 = e1 - e0;
	if( v10.x == 0.0f )
	{
		if( v10.x < aabb.min_x() || aabb.max_x() < v10.x ) return false;
	}
	else
	{
		float t_top = ( aabb.min_x() - e0.x ) / v10.x;
		float t_end = ( aabb.max_x() - e0.x ) / v10.x;
		if( t_top > t_end ) std::swap( t_top , t_end );

		t_top_max = (std::max)( t_top_max , t_top );
		t_end_min = (std::min)( t_end_min , t_end );
		if( t_top_max > t_end_min ) return false;
	}

	if( v10.y == 0.0f )
	{
		if( v10.y < aabb.min_y() || aabb.max_y() < v10.y ) return false;
	}
	else
	{
		float t_top = ( aabb.min_y() - e0.y ) / v10.y;
		float t_end = ( aabb.max_y() - e0.y ) / v10.y;
		if( t_top > t_end ) std::swap( t_top , t_end );

		t_top_max = (std::max)( t_top_max , t_top );
		t_end_min = (std::min)( t_end_min , t_end );
		if( t_top_max > t_end_min ) return false;
	}

	return true;
}


//! _3p`ɓĂ邩ׂ
float Geom2d::Intersect_Triangle_Point( const vec3f& t0 , const vec3f& t1 , const vec3f& t2 , const vec3f& p )
{
	vec2f d10( t1.x - t0.x , t1.y - t0.y );
	vec2f d21( t2.x - t1.x , t2.y - t1.y );
	vec2f d02( t0.x - t2.x , t0.y - t2.y );

	vec2f dp0( p.x - t0.x , p.y - t0.y );
	vec2f dp1( p.x - t1.x , p.y - t1.y );
	vec2f dp2( p.x - t2.x , p.y - t2.y );

	float nd0 = dp0.x * d10.y - dp0.y * d10.x;
	float nd1 = dp1.x * d21.y - dp1.y * d21.x;
	if( ( nd0 * nd1 ) < 0.0f ) return false;
	float nd2 = dp2.x * d02.y - dp2.y * d02.x;
	if( ( nd1 * nd2 ) < 0.0f ) return false;

	return true;
}


//! e0-e1ŁApɍł߂_߂.
//! @param[in]  e0 , e1  - ̒[_
//! @param[in]  p        - _̈ʒu
lm::vec3f Geom2d::Closest_Segment_Point( const vec3f& e0 , const vec3f& e1 , const vec3f& p )
{
	float dummy_weight;
	return Closest_Segment_Point( e0 , e1 , p , dummy_weight );
}

//! e0-e1ŁApɍł߂_߂.
//! @param[in]  e0 , e1  - ̒[_
//! @param[in]  p        - _̈ʒu
//! @param[out] o_weight - returnW̐e0-e1ł̐Kʒu.
lm::vec3f Geom2d::Closest_Segment_Point( const vec3f& e0 , const vec3f& e1 , const vec3f& p , float& o_weight )
{
	// xyʂɓe
	vec2f e0_2d ( e0.x , e0.y );
	vec2f e1_2d ( e1.x , e1.y );
	vec2f p_2d  ( p.x  , p.y  );

	// ̒0̏ꍇ
	if( e0_2d == e1_2d )
	{
		o_weight = 0.0f;

		// zWl͂e0e1̕ςgp
		return ( e0 + e1 ) * 0.5f;
	}
	else
	{
		vec2f e1_e0 = e1_2d - e0_2d;
		vec2f p_e0  = p_2d  - e0_2d;

		o_weight = dot( e1_e0 , p_e0 ) / dot( e1_e0 , e1_e0 );
		// l[ɐ
		o_weight = lm::clamp( 0.0f , o_weight , 1.0f );
		
		// zWle0e1̕Ԓlgp
		return ( e1 - e0 ) * o_weight + e0;
	}
}


//! _ō\ꂽȐlinepɍł߂_߂.
lm::vec3f Geom2d::Closest_CurveLine_Point( const std::vector<vec3f>& line , const vec3f& p )
{
	int dummy_segment_idx;
	float dummy_norm_pos;
	return Closest_CurveLine_Point( line , p , dummy_segment_idx , dummy_norm_pos );
}

//! _ō\ꂽȐlinepɍł߂_߂.
//! @param[in]  line          - Ȑ킷_
//! @param[in]  p             - lineƂ̍ŋߖT_𒲂ׂ_
//! @param[out] o_segment_idx - ŋߖT_ʒuZOg̃CfbNX
//! @param[out] o_norm_pos    - ZOgł̐Kʒu\l.
//! @retval - linepɂƋ߂_
lm::vec3f Geom2d::Closest_CurveLine_Point( const std::vector<vec3f>& line , const vec3f& p , int& o_segment_idx , float& o_norm_pos )
{
	// TODO : ł.

	_ASSERTE( line.size() >= 2 );

	vec3f closest_pos;
	float min_sq_length = (std::numeric_limits<float>::max)();
	o_segment_idx = -1;
	o_norm_pos = -1.0f;
	for( size_t i = 1 ; i < line.size() ; ++i )
	{
		int segment_idx = static_cast<int>(i-1);

		const vec3f& pos0 = line[i-1];
		const vec3f& pos1 = line[i  ];

		float weight;
		vec3f segment_closest = Closest_Segment_Point( pos0 , pos1 , p , weight );

		float dist_sq = ( p - segment_closest ).square_length();
		if( min_sq_length > dist_sq )
		{
			min_sq_length = dist_sq;

			closest_pos = segment_closest;
			o_segment_idx = segment_idx;
			o_norm_pos = weight;
		}
	}

	return closest_pos;
}


//! 2_xyʂƐȕ猩Ƃ̋߂
float Geom2d::DistanceXY( const vec3f& p0 , const vec3f& p1 )
{
	return sqrt( SqDistanceXY( p0 , p1 ) );
}

//! 2_xyʂƐȕ猩Ƃ̋̓߂
float Geom2d::SqDistanceXY( const vec3f& p0 , const vec3f& p1 )
{
	vec2f d( p0.x - p1.x , p0.y - p1.y );
	return d.square_length();
}


//! 3p`xyʂɓeƂ̖ʐςԂ
float Geom2d::AreaSize_Triangle( const vec3f& t0 , const vec3f& t1 , const vec3f& t2 )
{
	vec2f d01( t0.x - t1.x , t0.y - t1.y );
	vec2f d12( t1.x - t2.x , t1.y - t2.y );
	vec2f d20( t2.x - t0.x , t2.y - t0.y );

	float len0 = d01.length();
	float len1 = d12.length();
	float len2 = d20.length();

	// w̌
	float s = ( len0 + len1 + len2 ) / 0.5f;

	float sq = s * ( s - len0 ) * ( s - len1 ) * ( s - len2 );
	if( sq <= 0.0f ) return 0.0f;
	
	return sqrt( sq );
}


//! 3dxNg2dɓe
lm::vec2f Geom2d::Proj_To2d( const vec3f& v )
{
	return vec2f( v.x , v.y );
}


//! dSW擾. ( [ p = t0 * u + t1 * v + t2 * w ] ƂȂ u , v , w ߂ ).
//! @param[in]  t0 , t1 , t2 - Op`̒_W
//! @param[in]  p            - dSWvZ钸_
//! @param[out] u , v , w    - dSWl.
void Geom2d::Get_BaryCentCoord( const vec3f& t0 , const vec3f& t1 , const vec3f& t2 , const vec3f& p , float& u , float& v , float& w )
{
	vec3f v0 = t1 - t0;
	vec3f v1 = t2 - t0;
	vec3f v2 = p  - t0;
	v0.z = 0.0f;
	v1.z = 0.0f;
	v2.z = 0.0f;

	float d00 = dot( v0 , v0 );
	float d01 = dot( v0 , v1 );
	float d11 = dot( v1 , v1 );
	float d20 = dot( v2 , v0 );
	float d21 = dot( v2 , v1 );
	float denom = d00 * d11 - d01 * d01;
	v = ( d11 * d20 - d01 * d21 ) / denom;
	w = ( d00 * d21 - d01 * d20 ) / denom;
	u = 1.0f - v - w;
}

//! dSWvec3f̌`Ŏ擾.
void Geom2d::Get_BaryCentCoord( const vec3f& t0 , const vec3f& t1 , const vec3f& t2 , const vec3f& p , vec3f& bary_coord )
{
	Get_BaryCentCoord( t0 , t1 , t2 , p , bary_coord.x , bary_coord.y , bary_coord.z );
}


//! 2̃xNg̐p߂.
float Geom2d::Get_Angle( const vec3f& v0 , const vec3f& v1 )
{
	vec2f v20( v0.x , v0.y );
	vec2f v21( v1.x , v1.y );
	v20.normalize();
	v21.normalize();

	return acos( dot( v20 , v21 ) );
}

//! 2̃xNg̊px0`2PI͈̔͂ŋ߂.
float Geom2d::Get_RoundAngle( const vec3f& v0 , const vec3f& v1 )
{
	vec2f v20( v0.x , v0.y );  // v02D
	vec2f v21( v1.x , v1.y );  // v12D
	v20.normalize();
	v21.normalize();

	// v0 ƒ
	vec2f v20_perp = v20.get_perpendicular();

	// [ v0 , v0_perp ] ȂWnł, v1xWl.
	float v1_local_x = dot( v20 , v21 );
	if( v1_local_x >=  1.0f ) return 0.0f;
	if( v1_local_x <= -1.0f ) return static_cast<float>(M_PI);

	// [ v0 , v0_perp ] ȂWnł, v1yWl.
	float v1_local_y = dot( v20_perp , v21 );
	if( v1_local_y == 0.0f )
	{
		if( v1_local_x > 0.0f ) return 0.0f;
		else                    return static_cast<float>(M_PI);
	}
	else if( v1_local_y > 0.0f )
	{
		return acos( v1_local_x );
	}
	else
	{
		return 2.0f * static_cast<float>(M_PI) - acos( v1_local_x );
	}
}


}
