#pragma once

#include "../graph/Color.h"

#include "GlInclude.h"


namespace lib_gl
{


//! 
class Light
{
public:
	Light(void) :
			m_Ambient  ( 1.0f , 1.0f , 1.0f , 1.0f ) ,
			m_Diffuse  ( 1.0f , 1.0f , 1.0f , 1.0f ) ,
			m_Specular ( 1.0f , 1.0f , 1.0f , 1.0f ) ,
			m_LightIndex( GL_LIGHT0 ) ,
			m_IsDirectional( true )
	{}
	Light( GLenum LightIndex ) :
			m_Ambient  ( 1.0f , 1.0f , 1.0f , 1.0f ) ,
			m_Diffuse  ( 1.0f , 1.0f , 1.0f , 1.0f ) ,
			m_Specular ( 1.0f , 1.0f , 1.0f , 1.0f ) ,
			m_LightIndex( LightIndex ) ,
			m_IsDirectional( true )
	{}

	// ̈ʒu̓WlԂ
	lm::vector4f GetPos4(void) const;

	void SetGL(void);

	//! OpenGLł̌CfbNXݒ/擾
	void SetLightIndex( GLenum i_LightIndex ){ m_LightIndex = i_LightIndex; }
	GLenum GetLightIndex(void) const { return m_LightIndex; }

	// Svf̋Px/At@ݒ
	void SetAllBrightness( float brightness );
	void SetAllBrightness( float brightness , float alpha );
	void SetAlphaAll( float i_alpha );


public:
	lib_graph::color4f m_Ambient;
	lib_graph::color4f m_Diffuse;
	lib_graph::color4f m_Specular;

	lm::vec3f  m_Position;      //!< ʒuA܂͕\.
	bool       m_IsDirectional; //!< sȂtrue , _Ȃfalse

protected:
	GLenum  m_LightIndex; //!< GL_LIGHT0 ̌̃CfbNX
};



//! ̈ʒu̓WlԂ
inline
lm::vector4f Light::GetPos4(void) const
{
	lm::vector4f pos4( m_Position.x , m_Position.y , m_Position.z , 0.0f );
	pos4.w = m_IsDirectional ? 0.0f : 1.0f;
	return pos4;
}

//! ݒ̓Kp
inline
void Light::SetGL(void)
{
	glLightfv( m_LightIndex , GL_AMBIENT  , m_Ambient.v()  );
	glLightfv( m_LightIndex , GL_DIFFUSE  , m_Diffuse.v()  );
	glLightfv( m_LightIndex , GL_SPECULAR , m_Specular.v() );

	lm::vector4f pos4 = GetPos4();
	glLightfv( m_LightIndex , GL_POSITION , pos4.v() );
}

//! Svf̋Pxlɐݒ肷
inline
void Light::SetAllBrightness( float brightness )
{
	const float& b = brightness;
	m_Ambient.set( b , b , b , m_Ambient.a() );
	m_Diffuse.set( b , b , b , m_Diffuse.a() );
	m_Specular.set( b , b , b , m_Specular.a() );
}

//! Svf̋PxƃAt@llɐݒ肷
inline
void Light::SetAllBrightness( float brightness , float alpha )
{
	const float& b = brightness;
	const float& a = alpha;
	m_Ambient.set( b , b , b , a );
	m_Diffuse.set( b , b , b , a );
	m_Specular.set( b , b , b , a );
}

//! Svf̃At@llɐݒ肷
inline
void Light::SetAlphaAll( float i_alpha )
{
	m_Ambient.a()  = i_alpha;
	m_Diffuse.a()  = i_alpha;
	m_Specular.a() = i_alpha;
}


}
