#pragma once

#include <C2/gl/GlslPhongShader.h>

#include "ShaderInterface.h"



class PhongShader : public ShaderInterface
{
public:
	PhongShader(ShaderContext* context) :
		ShaderInterface(context)
	{
		m_NumPhonghSahderLights = 1;
	}

	const char* GetShaderName(void)
	{
		return "PhongShader";
	}

	void Initialize(int num_light);

	virtual void BeginShader(void);
	virtual void EndShader(void);

	virtual void SetTextureEnabled(bool enabled);
	virtual void SetTextureSpecularSeparate(bool enabled);

	virtual void SetDublesideEnabled(bool enabled);
	virtual void SetLightingEnabled(bool enabled);

public:
	lib_gl::GlslPhongShader m_PhongShader;
	int m_NumPhonghSahderLights;
};
