#pragma once

#include <QMouseEvent>



class MouseButtons
{
public:
	MouseButtons(void)
	{
		Left  = false;
		Mid   = false;
		Right = false;
	}

	MouseButtons(const QMouseEvent* e)
	{
		FromQtEvent(e);
	}

	void FromQtEvent(const QMouseEvent* e)
	{
		Left  = ( e->buttons() == Qt::LeftButton  );
		Mid   = ( e->buttons() == Qt::MidButton   );
		Right = ( e->buttons() == Qt::RightButton );
	}
	
	bool IsLeftOnly(void) const
	{
		return Left && !Mid && !Right;
	}

	bool IsMidOnly(void) const
	{
		return !Left && Mid && !Right;
	}

	bool IsRightOnly(void) const
	{
		return !Left && !Mid && Right;
	}

public:
	bool Left;
	bool Mid;
	bool Right;
};

