#pragma once

#include <LibQtGeoViewerCore/VBOHelper.h>



namespace lib_geo
{
class BaseMesh;
}

class GeometryVBO;

namespace geom
{
class FaceGroup;
}


//! ܂obt@L̂Ȃ, Op`̃Xĝ݂ō\VBOobt@.
//! y͂Ȃ舫.
class VBOBuilder
{
public:
	void CreateFromFaceGroup(GeometryVBO* vbo, lib_geo::BaseMesh& mesh, const geom::FaceGroup& fg);

private:
	void ClearReserve(size_t num_triangles, bool enable_normal, bool enable_uv);

	void BuildVBO(GeometryVBO* vbo);

	void IncrementIndex(void);

private:
	std::vector<lm::vec3f> verts;
	std::vector<lm::vec3f> norms;
	std::vector<lm::vec2f> uvs;
	std::vector<GLuint> indexbuf;
};
