#pragma once

#include <C2/lm/vector3.h>


namespace lib_geo
{


//! 3p`
struct Triangle
{
public:
	Triangle(void) {}
	Triangle( const lm::vec3f& i_p0 , const lm::vec3f& i_p1 , const lm::vec3f& i_p2 )
		: p0( i_p0 ) , p1( i_p1 ) , p2( i_p2 )
	{}

public:
	lm::vec3f p0 , p1 , p2;
};


//! 
struct Segment
{
public:
	Segment(void) {}
	Segment( const lm::vec3f& i_p0 , const lm::vec3f& i_p1 )
		: p0( i_p0 ) , p1( i_p1 )
	{}

public:
	lm::vec3f p0 , p1;
};


//! 
struct Plane
{
public:
	Plane(void) {}
	Plane( const lm::vec3f& i_normal , const lm::vec3f& i_origin ) :
		normal( i_normal ) , origin( i_origin )
	{}

	void SetPlane(const lm::vec3f& i_normal, const lm::vec3f& i_origin)
	{
		normal = i_normal;
		origin = i_origin;
	}

public:
	lm::vec3f normal; //!< ʂ̖@
	lm::vec3f origin; //!< ʂ̒ʉߓ_
};


//! 
struct Sphere
{
public:
	Sphere(void) {}
	Sphere(const lm::vec3f& i_center, const float i_radius) :
		center(i_center),
		radius(i_radius)
	{}

public:
	lm::vec3f center;
	float     radius;
};


}
