#pragma once

#include <vector>

#include "../Mesh/BaseMesh.h"

#include "NamedElement.h"



namespace lib_geo
{


class ColladaMeshVertAttrib
{
public:
	lm::vec3f m_InitialPos;
};


class ColladaMesh : public lib_geo::BaseMesh , public NamedElement
{
public:
	void CreateAttrib(void)
	{
		m_VertAttr.resize( m_Verts.size() );
		for( size_t i = 0 ; i < m_Verts.size() ; ++i )
		{
			m_VertAttr[i].m_InitialPos = m_Verts[i];
		}
	}

public:
	std::vector<ColladaMeshVertAttrib> m_VertAttr;
};


}
