#pragma once

#include <LibGeo/Shape.h>


enum class CutAngle
{
	CUT_X_FORE,
	CUT_Y_FORE,
	CUT_Z_FORE,
	CUT_X_REV,
	CUT_Y_REV,
	CUT_Z_REV,
	CUT_FREE,
};


class CrossSectionConfig
{
public:
	CrossSectionConfig(void);

	void ApplyClipPlaneAxis(float t, float b);
	void ApplyCutPlaneAxis(float t, float b);

	void ApplyClipPlane(const lm::vec3f& p, const lm::vec3f& n);
	void ApplyCutPlane(const lm::vec3f& p, const lm::vec3f& n);

	void DisableGLClipPlane(void);

	void SetAxisClipPlane(GLenum plane, bool bFore, GLdouble height);

	float GetCurrentAxisCutPos(void) const;

	lm::vec3f GetCutAxis(void) const;

	bool IsCutFore(void) const;
	bool IsCutRev(void) const;

	bool IsCutX(void) const;
	bool IsCutY(void) const;
	bool IsCutZ(void) const;

	bool IsFreeCut(void) const;

	bool IsRequireUpdateCS(void) const;

	void GetCutPlane(const lm::range3f& tb, lib_geo::Plane& cutplane) const;

private:
	float GetCutAxisHeightParam(float t, float b) const;
	void GetCutPlaneFromXYZParam(const lm::range3f& tb, lib_geo::Plane& cutplane) const;

public:
	bool m_Enable;
	float m_CutPosX;
	float m_CutPosY;
	float m_CutPosZ;

	bool m_Ribbon;
	float m_RibbonRange;

	bool m_LineCS;
	bool m_MultiColor;

	bool m_ShowCutplane;

	bool m_EnableConvexHull;
	bool m_EnableShowLength;
	bool m_EnableShowCHLength;
	bool m_EnableCrossSectionGroup;

	bool m_Transparent;

	CutAngle m_CutAngle;
};
