#pragma once

#include "Mqo.h"
#include <iostream>


namespace lib_geo
{


typedef std::vector<std::string> StringAry;


// ---------------------------------------------------------------------------------------------
// MqoElement
// Mqot@C͂̕ɎgpIuWFNg
// ---------------------------------------------------------------------------------------------
class MqoElement
{
public:
	MqoElement( const std::string& elem_str ) : m_str(elem_str) {}

	std::string GetValueName(void) const;

	void GetParams( StringAry& o_params ) const;

	void GetValueNameAndParams( std::string& o_value , StringAry& o_params ) const;

public:
	std::string m_str; // p[^ƃp[^IvV܂ޕ
};
typedef std::vector<MqoElement> MqoElements;



// ---------------------------------------------------------------------------------------------
// MqoLineSeek
// Mqot@C̍s͕⏕NX
// ---------------------------------------------------------------------------------------------
class MqoLineSeek
{
public:
	MqoLineSeek(std::istream& ist) : m_ist(ist) {}

	bool LoadNext(void);

	const std::string& GetCurrent(void) const;

	std::string GetTopToken(void) const;

	void SpaceSplit(StringAry& o_str_ary) const;

	void ElementSplit(MqoElements& o_elems) const;

private:
	std::string   m_current_line;
	std::istream& m_ist;
};



// ---------------------------------------------------------------------------------------------
// MqoLoader
// Mqot@Cǂݍ݃NX
// ---------------------------------------------------------------------------------------------
class MqoLoader
{
public:
	bool Load( MqoObject& o_mqo , const std::string& filename );

private:
	bool Load( MqoObject& o_mqo , std::istream& ist );

	void Load_Scene( MqoObject& o_mqo , MqoLineSeek& line_seek );
	
	void Load_Materials( MqoObject& o_mqo , MqoLineSeek& line_seek );

	void Load_Object  ( MqoObject& o_mqo , MqoLineSeek& line_seek );

	void Load_Vertices( MqoMesh& o_obj , MqoLineSeek& line_seek );
	void Load_Faces   ( MqoMesh& o_obj , MqoLineSeek& line_seek );

	void InitNormals( MqoObject& o_mqo );
};


}
