// OpenCVˑ̃eNX`ݒ@\
// GL_BGRĝglew.hKv

#pragma once

#include <cassert>

#include "../TextureTypes.h"


namespace lib_gl
{


//! OpenCV̉摜(IplImage)OpenGL̃JgeNX`ɃZbg.
inline bool SetCVTexture( const IplImage* img , lib_gl::TEXTURE_MODE tex_mode = lib_gl::TEXTURE_NORMAL )
{
	_ASSERTE( img != NULL );
	if( img == NULL )
		return false;

	GLint  internal_format;
	GLenum pixel_format;
	GLenum value_type;

	if( img->nChannels == 3 )
	{
		internal_format = GL_RGB;
		pixel_format    = GL_BGR;
	}
	else if( img->nChannels == 4 )
	{
		internal_format = GL_RGBA;
		pixel_format    = GL_BGRA;
	}
	else
	{
		// Ήorsȃ`l
		_ASSERT( false );
		return false;
	}

	if( img->depth == 8 )
	{
		value_type = GL_UNSIGNED_BYTE;
	}
	else if( img->depth == 32 )
	{
		value_type = GL_FLOAT;
	}
	else
	{
		// Ήorsȃf[^^
		_ASSERT( false );
		return false;
	}

	if( tex_mode == TEXTURE_NORMAL )
	{
		glPixelStorei( GL_UNPACK_ALIGNMENT , img->align );

		glTexImage2D( GL_TEXTURE_2D
		            , 0
		            , internal_format
		            , img->width , img->height
		            , 0
		            , pixel_format , value_type
		            , img->imageData
		            );
	}
	else if( tex_mode == TEXTURE_MIPMAP )
	{
		glPixelStorei( GL_UNPACK_ALIGNMENT , img->align );

		gluBuild2DMipmaps( GL_TEXTURE_2D
		                 , internal_format
		                 , img->width , img->height
		                 , pixel_format , value_type
		                 , img->imageData
		                 );
	}
	else
	{
		_ASSERT( false );
		return false;
	}

	return true;
}


//! OpenCVŉ摜t@Cǂݍ, OpenGL̃JgeNX`ɃZbg.
inline bool LoadAndSetCVTexture( const char* filename , lib_gl::TEXTURE_MODE tex_mode = lib_gl::TEXTURE_NORMAL )
{
	IplImage* img = cvLoadImage( filename );
	if( img == NULL )
		return false;

	bool bSuccessed = SetCVTexture( img , tex_mode );

	cvReleaseImage( &img );

	return bSuccessed;
}


}
