﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace Psychlops
{
	public class Font
	{
		public static Font default_font;

		public enum Style { normal, italic, oblique };
		public enum Weight { normal=400, bold=700 };
		public double size;
		public int weight;
		public Style style;
		public string family;

		static Font()
		{
			default_font = new Font();
		}
		public Font()
		{
			size = 18;
			weight = (int)Weight.normal;
			style = Style.normal;
			//family = new string[1];
		}
		public Font(double size_, int weight_, Style style_, string family_)
		{
			size = size_;
			weight = weight_;
			style = style_;
			//family = new string[1];
			family = family_;
		}
		public Font(string family_, double size_, int weight_, Style style_)
		{
			size = size_;
			weight = weight_;
			style = style_;
			//family = new string[1];
			family = family_;
		}
		~Font()
		{
		}
	}

	public partial class Letters : Shape
	{
		protected string str_;
		protected Font font_;
		protected double width_, height_;
		public Point datum { get; set; }

		public enum HorizontalAlign { not_specified=-1, left=0, center, right };
		//public const HorizontalAlign NOT_SPECIFIED=HorizontalAlign.not_specified, TEXT_ALIGN_LEFT=HorizontalAlign.left, TEXT_ALIGN_CENTER = HorizontalAlign.center, TEXT_ALIGN_RIGHT=HorizontalAlign.right;
		public HorizontalAlign align;

		public Letters()
		{
			fill = Color.white;
			stroke = Stroke.null_line;
			str_ = "";
			font = Font.default_font;
			align = HorizontalAlign.left;
		}
		public Letters(String init_str)
		{
			fill = Color.white;
			stroke = Stroke.null_line;
			str_ = init_str;
			font_ = Font.default_font;
			align = HorizontalAlign.center;
		}
		public Letters(String init_str, Font init_font)
		{
			fill = Color.white;
			stroke = Stroke.null_line;
			str_ = init_str;
			font_ = init_font;
			align = HorizontalAlign.right;
		}
		~Letters()
		{
		}
		public Font font
		{
			get { return font_; }
			set { font_ = value; }
		}
		public Font getFont() { return font; }
		public string str
		{
			get { return str_; }
			set { str_ = value; }
		}
		public String getString() { return str; }
		public Figure centering(Point p)
		{
			datum = p;
			align = HorizontalAlign.center;
			return this;
		}
		public Figure shift(Point p)
		{
			datum = datum + p;
			return this;
		}
		public Letters locate(Point p)
		{
			datum = p;
			return this;
		}
		public Letters locate(double x, double y)
		{
			datum = new Point(x,y);
			return this;
		}

		public void draw()
		{
			Main.drawable.letters(this);
		}

		public Color fill { get; set; }
		public Stroke stroke { get; set; }

	}

}
