/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class EvilUnclosedBRFixingInputStream
extends InputStream {
    private InputStream source;
    private byte[] spare;
    private static byte[] detect = new byte[]{60, 98, 114, 62};

    public EvilUnclosedBRFixingInputStream(InputStream source) {
        this.source = source;
    }

    public int read() throws IOException {
        return this.source.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int readA = this.readFromSpare(b, off, len);
        int readB = this.source.read(b, off + readA, len - readA);
        int read = readB == -1 || readB == 0 ? readA : readA + readB;
        if (read > 0) {
            read = this.fixUp(b, off, read);
        }
        return read;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    private int readFromSpare(byte[] b, int offset, int len) {
        if (this.spare == null) {
            return 0;
        }
        if (len == 0) {
            throw new IllegalArgumentException("Asked to read 0 bytes");
        }
        if (this.spare.length <= len) {
            System.arraycopy(this.spare, 0, b, offset, this.spare.length);
            int read = this.spare.length;
            this.spare = null;
            return read;
        }
        byte[] newspare = new byte[this.spare.length - len];
        System.arraycopy(this.spare, 0, b, offset, len);
        System.arraycopy(this.spare, len, newspare, 0, newspare.length);
        this.spare = newspare;
        return len;
    }

    private void addToSpare(byte[] b, int offset, int len, boolean atTheEnd) {
        if (this.spare == null) {
            this.spare = new byte[len];
            System.arraycopy(b, offset, this.spare, 0, len);
        } else {
            byte[] newspare = new byte[this.spare.length + len];
            if (atTheEnd) {
                System.arraycopy(this.spare, 0, newspare, 0, this.spare.length);
                System.arraycopy(b, offset, newspare, this.spare.length, len);
            } else {
                System.arraycopy(b, offset, newspare, 0, len);
                System.arraycopy(this.spare, 0, newspare, len, this.spare.length);
            }
            this.spare = newspare;
        }
    }

    private int fixUp(byte[] b, int offset, int read) {
        int j;
        boolean going;
        int i = 0;
        while (i < detect.length - 1) {
            int base = offset + read - 1 - i;
            if (base >= 0) {
                going = true;
                j = 0;
                while (j <= i && going) {
                    if (b[base + j] != detect[j]) {
                        going = false;
                    }
                    ++j;
                }
                if (going) {
                    this.addToSpare(b, base, i + 1, true);
                    --read;
                    read -= i;
                    break;
                }
            }
            ++i;
        }
        ArrayList<Integer> fixAt = new ArrayList<Integer>();
        int i2 = offset;
        while (i2 <= offset + read - detect.length) {
            going = true;
            j = 0;
            while (j < detect.length && going) {
                if (b[i2 + j] != detect[j]) {
                    going = false;
                }
                ++j;
            }
            if (going) {
                fixAt.add(new Integer(i2));
            }
            ++i2;
        }
        if (fixAt.size() == 0) {
            return read;
        }
        int needed = offset + read + fixAt.size();
        int overshoot = needed - b.length;
        if (overshoot > 0) {
            int fixes = 0;
            Iterator iterator = fixAt.iterator();
            while (iterator.hasNext()) {
                int at = (Integer)iterator.next();
                if (at > offset + read - detect.length - overshoot - fixes) {
                    overshoot = needed - at - 1 - fixes;
                    break;
                }
                ++fixes;
            }
            this.addToSpare(b, offset + read - overshoot, overshoot, false);
            read -= overshoot;
        }
        j = fixAt.size() - 1;
        while (j >= 0) {
            int i3 = (Integer)fixAt.get(j);
            if (i3 < read + offset && i3 <= read - 3) {
                byte[] tmp = new byte[read - i3 - 3];
                System.arraycopy(b, i3 + 3, tmp, 0, tmp.length);
                b[i3 + 3] = 47;
                System.arraycopy(tmp, 0, b, i3 + 4, tmp.length);
                ++read;
            }
            --j;
        }
        return read;
    }
}

