/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.util.Iterator;
import java.util.TreeMap;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.xssf.model.CalculationChain;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRow;

public class XSSFRow
implements Row,
Comparable {
    private static final POILogger _logger;
    private final CTRow _row;
    private final TreeMap _cells;
    private final XSSFSheet _sheet;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.xssf.usermodel.XSSFRow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _logger = POILogFactory.getLogger((Class)clazz);
    }

    protected XSSFRow(CTRow row, XSSFSheet sheet) {
        this._row = row;
        this._sheet = sheet;
        this._cells = new TreeMap();
        int i = 0;
        while (i < row.getCArray().length) {
            CTCell c = row.getCArray()[i];
            XSSFCell cell = new XSSFCell(this, c);
            this._cells.put(new Integer(cell.getColumnIndex()), cell);
            sheet.onReadCell(cell);
            ++i;
        }
    }

    public Sheet getSheet() {
        return this._sheet;
    }

    public Iterator cellIterator() {
        return this._cells.values().iterator();
    }

    public Iterator iterator() {
        return this.cellIterator();
    }

    public int compareTo(Object in_row) {
        XSSFRow row = (XSSFRow)in_row;
        int thisVal = this.getRowNum();
        if (row.getSheet() != this.getSheet()) {
            throw new IllegalArgumentException("The compared rows must belong to the same XSSFSheet");
        }
        int anotherVal = row.getRowNum();
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    public Cell createCell(int columnIndex) {
        return this.createCell(columnIndex, 3);
    }

    public Cell createCell(int columnIndex, int type) {
        CTCell ctCell;
        XSSFCell prev = (XSSFCell)this._cells.get(new Integer(columnIndex));
        if (prev != null) {
            ctCell = prev.getCTCell();
            ctCell.set((XmlObject)CTCell.Factory.newInstance());
        } else {
            ctCell = this._row.addNewC();
        }
        XSSFCell xcell = new XSSFCell(this, ctCell);
        xcell.setCellNum(columnIndex);
        if (type != 3) {
            xcell.setCellType(type);
        }
        this._cells.put(new Integer(columnIndex), xcell);
        return xcell;
    }

    public Cell getCell(int cellnum) {
        return this.getCell(cellnum, this._sheet.getWorkbook().getMissingCellPolicy());
    }

    public Cell getCell(int cellnum, Row.MissingCellPolicy policy) {
        if (cellnum < 0) {
            throw new IllegalArgumentException("Cell index must be >= 0");
        }
        XSSFCell cell = (XSSFCell)this._cells.get(new Integer(cellnum));
        if (policy == RETURN_NULL_AND_BLANK) {
            return cell;
        }
        if (policy == RETURN_BLANK_AS_NULL) {
            if (cell == null) {
                return cell;
            }
            if (cell.getCellType() == 3) {
                return null;
            }
            return cell;
        }
        if (policy == CREATE_NULL_AS_BLANK) {
            if (cell == null) {
                return this.createCell((short)cellnum, 3);
            }
            return cell;
        }
        throw new IllegalArgumentException("Illegal policy " + policy + " (" + policy.id + ")");
    }

    public short getFirstCellNum() {
        return (short)(this._cells.size() == 0 ? -1 : (Integer)this._cells.firstKey());
    }

    public short getLastCellNum() {
        return (short)(this._cells.size() == 0 ? -1 : (Integer)this._cells.lastKey() + 1);
    }

    public short getHeight() {
        return (short)(this.getHeightInPoints() * 20.0f);
    }

    public float getHeightInPoints() {
        if (this._row.isSetHt()) {
            return (float)this._row.getHt();
        }
        return this._sheet.getDefaultRowHeightInPoints();
    }

    public void setHeight(short height) {
        if (height == -1) {
            if (this._row.isSetHt()) {
                this._row.unsetHt();
            }
            if (this._row.isSetCustomHeight()) {
                this._row.unsetCustomHeight();
            }
        } else {
            this._row.setHt((double)height / 20.0);
            this._row.setCustomHeight(true);
        }
    }

    public void setHeightInPoints(float height) {
        this.setHeight((short)(height == -1.0f ? -1.0f : height * 20.0f));
    }

    public int getPhysicalNumberOfCells() {
        return this._cells.size();
    }

    public int getRowNum() {
        return (int)(this._row.getR() - 1L);
    }

    public void setRowNum(int rowIndex) {
        int maxrow = SpreadsheetVersion.EXCEL2007.getLastRowIndex();
        if (rowIndex < 0 || rowIndex > maxrow) {
            throw new IllegalArgumentException("Invalid row number (" + rowIndex + ") outside allowable range (0.." + maxrow + ")");
        }
        this._row.setR((long)(rowIndex + 1));
    }

    public boolean getZeroHeight() {
        return this._row.getHidden();
    }

    public void setZeroHeight(boolean height) {
        this._row.setHidden(height);
    }

    public boolean isFormatted() {
        return this._row.isSetS();
    }

    public CellStyle getRowStyle() {
        if (!this.isFormatted()) {
            return null;
        }
        StylesTable stylesSource = ((XSSFWorkbook)this.getSheet().getWorkbook()).getStylesSource();
        if (stylesSource.getNumCellStyles() > 0) {
            return stylesSource.getStyleAt((int)this._row.getS());
        }
        return null;
    }

    public void setRowStyle(CellStyle style) {
        if (style == null) {
            if (this._row.isSetS()) {
                this._row.unsetS();
                this._row.unsetCustomFormat();
            }
        } else {
            StylesTable styleSource = ((XSSFWorkbook)this.getSheet().getWorkbook()).getStylesSource();
            XSSFCellStyle xStyle = (XSSFCellStyle)style;
            xStyle.verifyBelongsToStylesSource(styleSource);
            long idx = styleSource.putStyle(xStyle);
            this._row.setS(idx);
            this._row.setCustomFormat(true);
        }
    }

    public void removeCell(Cell cell) {
        if (cell.getRow() != this) {
            throw new IllegalArgumentException("Specified cell does not belong to this row");
        }
        XSSFCell xcell = (XSSFCell)cell;
        if (xcell.isPartOfArrayFormulaGroup()) {
            xcell.notifyArrayFormulaChanging();
        }
        if (cell.getCellType() == 2) {
            ((XSSFWorkbook)this._sheet.getWorkbook()).onDeleteFormula(xcell);
        }
        this._cells.remove(new Integer(cell.getColumnIndex()));
    }

    public CTRow getCTRow() {
        return this._row;
    }

    protected void onDocumentWrite() {
        boolean isOrdered = true;
        if (this._row.sizeOfCArray() != this._cells.size()) {
            isOrdered = false;
        } else {
            int i = 0;
            Iterator iterator = this._cells.values().iterator();
            while (iterator.hasNext()) {
                XSSFCell cell = (XSSFCell)iterator.next();
                CTCell c1 = cell.getCTCell();
                CTCell c2 = this._row.getCArray(i++);
                String r1 = c1.getR();
                String r2 = c2.getR();
                if (!(r1 == null ? r2 != null : !r1.equals(r2))) continue;
                isOrdered = false;
                break;
            }
        }
        if (!isOrdered) {
            CTCell[] cArray = new CTCell[this._cells.size()];
            int i = 0;
            Iterator iterator = this._cells.values().iterator();
            while (iterator.hasNext()) {
                XSSFCell c = (XSSFCell)iterator.next();
                cArray[i++] = c.getCTCell();
            }
            this._row.setCArray(cArray);
        }
    }

    public String toString() {
        return this._row.toString();
    }

    protected void shift(int n) {
        int rownum = this.getRowNum() + n;
        CalculationChain calcChain = ((XSSFWorkbook)this._sheet.getWorkbook()).getCalculationChain();
        int sheetId = (int)this._sheet.sheet.getSheetId();
        String msg = "Row[rownum=" + this.getRowNum() + "] contains cell(s) included in a multi-cell array formula. " + "You cannot change part of an array.";
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Cell c = (Cell)iterator.next();
            XSSFCell cell = (XSSFCell)c;
            if (cell.isPartOfArrayFormulaGroup()) {
                cell.notifyArrayFormulaChanging(msg);
            }
            if (calcChain != null) {
                calcChain.removeItem(sheetId, cell.getReference());
            }
            CTCell ctCell = cell.getCTCell();
            String r = new CellReference(rownum, cell.getColumnIndex()).formatAsString();
            ctCell.setR(r);
        }
        this.setRowNum(rownum);
    }
}

