/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.xssf.model.MapInfo;
import org.apache.poi.xssf.model.SingleXmlCells;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFTable;
import org.apache.poi.xssf.usermodel.helpers.XSSFSingleXmlCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTMap;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSchema;
import org.w3c.dom.Node;

public class XSSFMap {
    private CTMap ctMap;
    private MapInfo mapInfo;

    public XSSFMap(CTMap ctMap, MapInfo mapInfo) {
        this.ctMap = ctMap;
        this.mapInfo = mapInfo;
    }

    public CTMap getCtMap() {
        return this.ctMap;
    }

    public CTSchema getCTSchema() {
        String schemaId = this.ctMap.getSchemaID();
        return this.mapInfo.getCTSchemaById(schemaId);
    }

    public Node getSchema() {
        Node xmlSchema = null;
        CTSchema schema = this.getCTSchema();
        xmlSchema = schema.getDomNode().getFirstChild();
        return xmlSchema;
    }

    public List getRelatedSingleXMLCell() {
        Vector<XSSFSingleXmlCell> relatedSimpleXmlCells = new Vector<XSSFSingleXmlCell>();
        int sheetNumber = this.mapInfo.getWorkbook().getNumberOfSheets();
        int i = 0;
        while (i < sheetNumber) {
            XSSFSheet sheet = (XSSFSheet)this.mapInfo.getWorkbook().getSheetAt(i);
            Iterator iterator = sheet.getRelations().iterator();
            while (iterator.hasNext()) {
                POIXMLDocumentPart p = (POIXMLDocumentPart)iterator.next();
                if (!(p instanceof SingleXmlCells)) continue;
                SingleXmlCells singleXMLCells = (SingleXmlCells)p;
                Iterator iterator2 = singleXMLCells.getAllSimpleXmlCell().iterator();
                while (iterator2.hasNext()) {
                    XSSFSingleXmlCell cell = (XSSFSingleXmlCell)iterator2.next();
                    if (cell.getMapId() != this.ctMap.getID()) continue;
                    relatedSimpleXmlCells.add(cell);
                }
            }
            ++i;
        }
        return relatedSimpleXmlCells;
    }

    public List getRelatedTables() {
        Vector<XSSFTable> tables = new Vector<XSSFTable>();
        int sheetNumber = this.mapInfo.getWorkbook().getNumberOfSheets();
        int i = 0;
        while (i < sheetNumber) {
            XSSFSheet sheet = (XSSFSheet)this.mapInfo.getWorkbook().getSheetAt(i);
            Iterator iterator = sheet.getRelations().iterator();
            while (iterator.hasNext()) {
                XSSFTable table;
                POIXMLDocumentPart p = (POIXMLDocumentPart)iterator.next();
                if (!p.getPackageRelationship().getRelationshipType().equals(XSSFRelation.TABLE.getRelation()) || !(table = (XSSFTable)p).mapsTo(this.ctMap.getID())) continue;
                tables.add(table);
            }
            ++i;
        }
        return tables;
    }
}

