/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.eventusermodel;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ReadOnlySharedStringsTable
extends DefaultHandler {
    private int count;
    private int uniqueCount;
    private List strings;
    private StringBuffer characters;
    private boolean tIsOpen;

    public ReadOnlySharedStringsTable(OPCPackage pkg) throws IOException, SAXException {
        ArrayList parts = pkg.getPartsByContentType(XSSFRelation.SHARED_STRINGS.getContentType());
        if (parts.size() > 0) {
            PackagePart sstPart = (PackagePart)parts.get(0);
            this.readFrom(sstPart.getInputStream());
        }
    }

    public ReadOnlySharedStringsTable(PackagePart part, PackageRelationship rel_ignored) throws IOException, SAXException {
        this.readFrom(part.getInputStream());
    }

    public void readFrom(InputStream is) throws IOException, SAXException {
        InputSource sheetSource = new InputSource(is);
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = saxFactory.newSAXParser();
            XMLReader sheetParser = saxParser.getXMLReader();
            sheetParser.setContentHandler(this);
            sheetParser.parse(sheetSource);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("SAX parser appears to be broken - " + e.getMessage());
        }
    }

    public int getCount() {
        return this.count;
    }

    public int getUniqueCount() {
        return this.uniqueCount;
    }

    public String getEntryAt(int idx) {
        return (String)this.strings.get(idx);
    }

    public List getItems() {
        return this.strings;
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if ("sst".equals(name)) {
            String uniqueCount;
            String count = attributes.getValue("count");
            if (count != null) {
                this.count = Integer.parseInt(count);
            }
            if ((uniqueCount = attributes.getValue("uniqueCount")) != null) {
                this.uniqueCount = Integer.parseInt(uniqueCount);
            }
            this.strings = new ArrayList(this.uniqueCount);
            this.characters = new StringBuffer();
        } else if ("si".equals(name)) {
            this.characters.setLength(0);
        } else if ("t".equals(name)) {
            this.tIsOpen = true;
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if ("si".equals(name)) {
            this.strings.add(this.characters.toString());
        } else if ("t".equals(name)) {
            this.tIsOpen = false;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.tIsOpen) {
            this.characters.append(ch, start, length);
        }
    }
}

