/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.util.Units;
import org.apache.poi.xslf.usermodel.XSLFTable;
import org.apache.poi.xslf.usermodel.XSLFTableCell;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableCell;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableRow;
import poi.support.Iterable;

public class XSLFTableRow
implements Iterable {
    private CTTableRow _row;
    private List _cells;
    private XSLFTable _table;

    XSLFTableRow(CTTableRow row, XSLFTable table) {
        this._row = row;
        this._table = table;
        this._cells = new ArrayList(this._row.sizeOfTcArray());
        Iterator<CTTableCell> iterator = Arrays.asList(this._row.getTcArray()).iterator();
        while (iterator.hasNext()) {
            CTTableCell cell = iterator.next();
            this._cells.add(new XSLFTableCell(cell, table.getSheet()));
        }
    }

    public CTTableRow getXmlObject() {
        return this._row;
    }

    public Iterator iterator() {
        return this._cells.iterator();
    }

    public List getCells() {
        return Collections.unmodifiableList(this._cells);
    }

    public double getHeight() {
        return Units.toPoints(this._row.getH());
    }

    public void setHeight(double height) {
        this._row.setH((long)Units.toEMU(height));
    }

    public XSLFTableCell addCell() {
        CTTableCell c = this._row.addNewTc();
        c.set((XmlObject)XSLFTableCell.prototype());
        XSLFTableCell cell = new XSLFTableCell(c, this._table.getSheet());
        this._cells.add(cell);
        if (this._table.getNumberOfColumns() < this._row.sizeOfTcArray()) {
            this._table.getCTTable().getTblGrid().addNewGridCol().setW((long)Units.toEMU(100.0));
        }
        return cell;
    }
}

