/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.POIXMLException;
import org.apache.poi.xslf.usermodel.DrawingParagraph;
import org.apache.poi.xslf.usermodel.DrawingTable;
import org.apache.poi.xslf.usermodel.DrawingTableCell;
import org.apache.poi.xslf.usermodel.DrawingTableRow;
import org.apache.poi.xslf.usermodel.DrawingTextBody;
import org.apache.poi.xslf.usermodel.DrawingTextPlaceholder;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.values.XmlAnyTypeImpl;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObjectData;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTable;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.presentationml.x2006.main.CTApplicationNonVisualDrawingProps;
import org.openxmlformats.schemas.presentationml.x2006.main.CTCommonSlideData;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGraphicalObjectFrame;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGroupShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;

public class XSLFCommonSlideData {
    private final CTCommonSlideData data;

    public XSLFCommonSlideData(CTCommonSlideData data) {
        this.data = data;
    }

    public List getDrawingText() {
        CTGroupShape gs = this.data.getSpTree();
        ArrayList<DrawingTextBody> out = new ArrayList<DrawingTextBody>();
        this.processShape(gs, out);
        Iterator<CTGroupShape> iterator = Arrays.asList(gs.getGrpSpArray()).iterator();
        while (iterator.hasNext()) {
            CTGroupShape shape = iterator.next();
            this.processShape(shape, out);
        }
        iterator = Arrays.asList(gs.getGraphicFrameArray()).iterator();
        while (iterator.hasNext()) {
            CTGraphicalObjectFrame frame = (CTGraphicalObjectFrame)iterator.next();
            CTGraphicalObjectData data = frame.getGraphic().getGraphicData();
            XmlCursor c = data.newCursor();
            c.selectPath("declare namespace pic='" + CTTable.type.getName().getNamespaceURI() + "' .//pic:tbl");
            while (c.toNextSelection()) {
                XmlObject o = c.getObject();
                if (o instanceof XmlAnyTypeImpl) {
                    try {
                        o = CTTable.Factory.parse((String)o.toString());
                    }
                    catch (XmlException e) {
                        throw new POIXMLException(e);
                    }
                }
                if (!(o instanceof CTTable)) continue;
                DrawingTable table = new DrawingTable((CTTable)o);
                int i = 0;
                while (i < table.getRows().length) {
                    DrawingTableRow row = table.getRows()[i];
                    int j = 0;
                    while (j < row.getCells().length) {
                        DrawingTableCell cell = row.getCells()[j];
                        DrawingTextBody textBody = cell.getTextBody();
                        out.add(textBody);
                        ++j;
                    }
                    ++i;
                }
            }
            c.dispose();
        }
        return out;
    }

    public List getText() {
        ArrayList<DrawingParagraph> paragraphs = new ArrayList<DrawingParagraph>();
        Iterator iterator = this.getDrawingText().iterator();
        while (iterator.hasNext()) {
            DrawingTextBody textBody = (DrawingTextBody)iterator.next();
            paragraphs.addAll(Arrays.asList(textBody.getParagraphs()));
        }
        return paragraphs;
    }

    private void processShape(CTGroupShape gs, List out) {
        List<CTShape> shapes = Arrays.asList(gs.getSpArray());
        Iterator<CTShape> iterator = shapes.iterator();
        while (iterator.hasNext()) {
            CTShape shape = iterator.next();
            CTTextBody ctTextBody = shape.getTxBody();
            if (ctTextBody == null) continue;
            CTApplicationNonVisualDrawingProps nvpr = shape.getNvSpPr().getNvPr();
            DrawingTextBody textBody = nvpr.isSetPh() ? new DrawingTextPlaceholder(ctTextBody, nvpr.getPh()) : new DrawingTextBody(ctTextBody);
            out.add(textBody);
        }
    }
}

