/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.extractor;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xslf.XSLFSlideShow;
import org.apache.poi.xslf.usermodel.DrawingParagraph;
import org.apache.poi.xslf.usermodel.DrawingTextBody;
import org.apache.poi.xslf.usermodel.DrawingTextPlaceholder;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFCommentAuthors;
import org.apache.poi.xslf.usermodel.XSLFComments;
import org.apache.poi.xslf.usermodel.XSLFCommonSlideData;
import org.apache.poi.xslf.usermodel.XSLFNotes;
import org.apache.poi.xslf.usermodel.XSLFRelation;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFSlideLayout;
import org.apache.poi.xslf.usermodel.XSLFSlideMaster;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.presentationml.x2006.main.CTComment;
import org.openxmlformats.schemas.presentationml.x2006.main.CTCommentAuthor;

public class XSLFPowerPointExtractor
extends POIXMLTextExtractor {
    public static final XSLFRelation[] SUPPORTED_TYPES = new XSLFRelation[]{XSLFRelation.MAIN, XSLFRelation.MACRO, XSLFRelation.MACRO_TEMPLATE, XSLFRelation.PRESENTATIONML, XSLFRelation.PRESENTATIONML_TEMPLATE, XSLFRelation.PRESENTATION_MACRO};
    private XMLSlideShow slideshow;
    private boolean slidesByDefault = true;
    private boolean notesByDefault = false;
    private boolean masterByDefault = false;

    public XSLFPowerPointExtractor(XMLSlideShow slideshow) {
        super(slideshow);
        this.slideshow = slideshow;
    }

    public XSLFPowerPointExtractor(XSLFSlideShow slideshow) throws XmlException, IOException {
        this(new XMLSlideShow(slideshow.getPackage()));
    }

    public XSLFPowerPointExtractor(OPCPackage container) throws XmlException, OpenXML4JException, IOException {
        this(new XSLFSlideShow(container));
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Use:");
            System.err.println("  XSLFPowerPointExtractor <filename.pptx>");
            System.exit(1);
        }
        XSLFPowerPointExtractor extractor = new XSLFPowerPointExtractor(new XSLFSlideShow(args[0]));
        System.out.println(extractor.getText());
    }

    public void setSlidesByDefault(boolean slidesByDefault) {
        this.slidesByDefault = slidesByDefault;
    }

    public void setNotesByDefault(boolean notesByDefault) {
        this.notesByDefault = notesByDefault;
    }

    public void setMasterByDefault(boolean masterByDefault) {
        this.masterByDefault = masterByDefault;
    }

    public String getText() {
        return this.getText(this.slidesByDefault, this.notesByDefault);
    }

    public String getText(boolean slideText, boolean notesText) {
        return this.getText(slideText, notesText, this.masterByDefault);
    }

    public String getText(boolean slideText, boolean notesText, boolean masterText) {
        StringBuffer text = new StringBuffer();
        XSLFSlide[] slides = this.slideshow.getSlides();
        XSLFCommentAuthors commentAuthors = this.slideshow.getCommentAuthors();
        int i = 0;
        while (i < slides.length) {
            XSLFSlide slide = slides[i];
            try {
                XSLFNotes notes = slide.getNotes();
                XSLFComments comments = slide.getComments();
                XSLFSlideLayout layout = slide.getSlideLayout();
                XSLFSlideMaster master = layout.getSlideMaster();
                if (slideText) {
                    this.extractText(slide.getCommonSlideData(), false, text);
                    if (masterText) {
                        if (layout != null) {
                            this.extractText(layout.getCommonSlideData(), true, text);
                        }
                        if (master != null) {
                            this.extractText(master.getCommonSlideData(), true, text);
                        }
                    }
                    if (comments != null) {
                        List<CTComment> list = Arrays.asList(comments.getCTCommentsList().getCmArray());
                        Iterator<CTComment> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            CTCommentAuthor author;
                            CTComment comment = iterator.next();
                            if (commentAuthors != null && (author = commentAuthors.getAuthorById(comment.getAuthorId())) != null) {
                                text.append(String.valueOf(author.getName()) + ": ");
                            }
                            text.append(comment.getText());
                            text.append("\n");
                        }
                    }
                }
                if (notesText && notes != null) {
                    this.extractText(notes.getCommonSlideData(), false, text);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ++i;
        }
        return text.toString();
    }

    private void extractText(XSLFCommonSlideData data, boolean skipPlaceholders, StringBuffer text) {
        Iterator iterator = data.getDrawingText().iterator();
        while (iterator.hasNext()) {
            DrawingTextPlaceholder ph;
            DrawingTextBody textBody = (DrawingTextBody)iterator.next();
            if (skipPlaceholders && textBody instanceof DrawingTextPlaceholder && !(ph = (DrawingTextPlaceholder)textBody).isPlaceholderCustom()) continue;
            int i = 0;
            while (i < textBody.getParagraphs().length) {
                DrawingParagraph p = textBody.getParagraphs()[i];
                text.append((Object)p.getText());
                text.append("\n");
                ++i;
            }
        }
    }
}

