/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.openxml4j.opc.internal;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.InvalidOperationException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JRuntimeException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public abstract class ContentTypeManager {
    public static final String CONTENT_TYPES_PART_NAME = "[Content_Types].xml";
    public static final String TYPES_NAMESPACE_URI = "http://schemas.openxmlformats.org/package/2006/content-types";
    private static final String TYPES_TAG_NAME = "Types";
    private static final String DEFAULT_TAG_NAME = "Default";
    private static final String EXTENSION_ATTRIBUTE_NAME = "Extension";
    private static final String CONTENT_TYPE_ATTRIBUTE_NAME = "ContentType";
    private static final String OVERRIDE_TAG_NAME = "Override";
    private static final String PART_NAME_ATTRIBUTE_NAME = "PartName";
    protected OPCPackage container;
    private TreeMap defaultContentType;
    private TreeMap overrideContentType;

    public ContentTypeManager(InputStream in, OPCPackage pkg) throws InvalidFormatException {
        this.container = pkg;
        this.defaultContentType = new TreeMap();
        if (in != null) {
            try {
                this.parseContentTypesFile(in);
            }
            catch (InvalidFormatException e) {
                throw new InvalidFormatException("Can't read content types part !");
            }
        }
    }

    public void addContentType(PackagePartName partName, String contentType) {
        boolean defaultCTExists = false;
        String extension = partName.getExtension().toLowerCase();
        if (extension.length() == 0 || this.defaultContentType.containsKey(extension) && !(defaultCTExists = this.defaultContentType.containsValue(contentType))) {
            this.addOverrideContentType(partName, contentType);
        } else if (!defaultCTExists) {
            this.addDefaultContentType(extension, contentType);
        }
    }

    private void addOverrideContentType(PackagePartName partName, String contentType) {
        if (this.overrideContentType == null) {
            this.overrideContentType = new TreeMap();
        }
        this.overrideContentType.put(partName, contentType);
    }

    private void addDefaultContentType(String extension, String contentType) {
        this.defaultContentType.put(extension.toLowerCase(), contentType);
    }

    public void removeContentType(PackagePartName partName) throws InvalidOperationException {
        PackagePart part;
        Iterator iterator;
        if (partName == null) {
            throw new IllegalArgumentException("partName");
        }
        if (this.overrideContentType != null && this.overrideContentType.get(partName) != null) {
            this.overrideContentType.remove(partName);
            return;
        }
        String extensionToDelete = partName.getExtension();
        boolean deleteDefaultContentTypeFlag = true;
        if (this.container != null) {
            try {
                iterator = this.container.getParts().iterator();
                while (iterator.hasNext()) {
                    part = (PackagePart)iterator.next();
                    if (part.getPartName().equals(partName) || !part.getPartName().getExtension().equalsIgnoreCase(extensionToDelete)) continue;
                    deleteDefaultContentTypeFlag = false;
                    break;
                }
            }
            catch (InvalidFormatException e) {
                throw new InvalidOperationException(e.getMessage());
            }
        }
        if (deleteDefaultContentTypeFlag) {
            this.defaultContentType.remove(extensionToDelete);
        }
        if (this.container != null) {
            try {
                iterator = this.container.getParts().iterator();
                while (iterator.hasNext()) {
                    part = (PackagePart)iterator.next();
                    if (part.getPartName().equals(partName) || this.getContentType(part.getPartName()) != null) continue;
                    throw new InvalidOperationException("Rule M2.4 is not respected: Nor a default element or override element is associated with the part: " + part.getPartName().getName());
                }
            }
            catch (InvalidFormatException e) {
                throw new InvalidOperationException(e.getMessage());
            }
        }
    }

    public boolean isContentTypeRegister(String contentType) {
        if (contentType == null) {
            throw new IllegalArgumentException("contentType");
        }
        return this.defaultContentType.values().contains(contentType) || this.overrideContentType != null && this.overrideContentType.values().contains(contentType);
    }

    public String getContentType(PackagePartName partName) {
        if (partName == null) {
            throw new IllegalArgumentException("partName");
        }
        if (this.overrideContentType != null && this.overrideContentType.containsKey(partName)) {
            return (String)this.overrideContentType.get(partName);
        }
        String extension = partName.getExtension().toLowerCase();
        if (this.defaultContentType.containsKey(extension)) {
            return (String)this.defaultContentType.get(extension);
        }
        if (this.container != null && this.container.getPart(partName) != null) {
            throw new OpenXML4JRuntimeException("Rule M2.4 exception : this error should NEVER happen, if so please send a mail to the developers team, thanks !");
        }
        return null;
    }

    public void clearAll() {
        this.defaultContentType.clear();
        if (this.overrideContentType != null) {
            this.overrideContentType.clear();
        }
    }

    public void clearOverrideContentTypes() {
        if (this.overrideContentType != null) {
            this.overrideContentType.clear();
        }
    }

    private void parseContentTypesFile(InputStream in) throws InvalidFormatException {
        try {
            SAXReader xmlReader = new SAXReader();
            Document xmlContentTypetDoc = xmlReader.read(in);
            List defaultTypes = xmlContentTypetDoc.getRootElement().elements(DEFAULT_TAG_NAME);
            Iterator elementIteratorDefault = defaultTypes.iterator();
            while (elementIteratorDefault.hasNext()) {
                Element element = (Element)elementIteratorDefault.next();
                String extension = element.attribute(EXTENSION_ATTRIBUTE_NAME).getValue();
                String contentType = element.attribute(CONTENT_TYPE_ATTRIBUTE_NAME).getValue();
                this.addDefaultContentType(extension, contentType);
            }
            List overrideTypes = xmlContentTypetDoc.getRootElement().elements(OVERRIDE_TAG_NAME);
            Iterator elementIteratorOverride = overrideTypes.iterator();
            while (elementIteratorOverride.hasNext()) {
                Element element = (Element)elementIteratorOverride.next();
                URI uri = new URI(element.attribute(PART_NAME_ATTRIBUTE_NAME).getValue());
                PackagePartName partName = PackagingURIHelper.createPartName(uri);
                String contentType = element.attribute(CONTENT_TYPE_ATTRIBUTE_NAME).getValue();
                this.addOverrideContentType(partName, contentType);
            }
        }
        catch (URISyntaxException urie) {
            throw new InvalidFormatException(urie.getMessage());
        }
        catch (DocumentException e) {
            throw new InvalidFormatException(e.getMessage());
        }
    }

    public boolean save(OutputStream outStream) {
        Map.Entry entry;
        Document xmlOutDoc = DocumentHelper.createDocument();
        Namespace dfNs = Namespace.get((String)"", (String)TYPES_NAMESPACE_URI);
        Element typesElem = xmlOutDoc.addElement(new QName(TYPES_TAG_NAME, dfNs));
        Iterator iterator = this.defaultContentType.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            this.appendDefaultType(typesElem, entry);
        }
        if (this.overrideContentType != null) {
            iterator = this.overrideContentType.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                this.appendSpecificTypes(typesElem, entry);
            }
        }
        xmlOutDoc.normalize();
        return this.saveImpl(xmlOutDoc, outStream);
    }

    private void appendSpecificTypes(Element root, Map.Entry entry) {
        root.addElement(OVERRIDE_TAG_NAME).addAttribute(PART_NAME_ATTRIBUTE_NAME, ((PackagePartName)entry.getKey()).getName()).addAttribute(CONTENT_TYPE_ATTRIBUTE_NAME, (String)entry.getValue());
    }

    private void appendDefaultType(Element root, Map.Entry entry) {
        root.addElement(DEFAULT_TAG_NAME).addAttribute(EXTENSION_ATTRIBUTE_NAME, (String)entry.getKey()).addAttribute(CONTENT_TYPE_ATTRIBUTE_NAME, (String)entry.getValue());
    }

    public abstract boolean saveImpl(Document var1, OutputStream var2);
}

