/*
 * Created on 2005/07/01
 * 
 * Copyright (C) 2005- Monami software, LP.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Monami software, LP. - Initial API and implementation
 */
package jp.pizzafactory.debug.core;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.Thread;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MITargetDownload;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;

/**
 * @author monaka
 */
public class SingleThreadTarget extends Target {

	/**
	 * @param s
	 * @param mi
	 */
	public SingleThreadTarget(Session s, MISession mi) {
		super(s, mi);
	}

	public Thread[] getCThreads() throws CDIException {
		try {
			return super.getCThreads();
		} catch (CDIException e) {
			/* nothing special to do. */
		}
		return new Thread[] { new Thread(this, 0) };
	}

	public void load() throws CDIException {
		MISession miSession = getMISession();
		CommandFactory factory = miSession.getCommandFactory();
		MITargetDownload download = new MITargetDownload(factory.getMIVersion());
		try {
			miSession.postCommand(download);
			MIInfo info = download.getMIInfo();
			if (info == null) {
				throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding")); //$NON-NLS-1$
			}
		} catch (MIException e) {
			throw new MI2CDIException(e);
		}
		
	}
}
