/*
 * Created on 2007/02/17
 *
 * Copyright (C) 2005- Monami software, LP.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Monami software, LP. - Initial API and implementation
 */
package jp.pizzafactory.crosschains.managedbuild.dynamicelement;

import java.util.ArrayList;

import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElementProvider;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.ProjectType;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class DefaultManagedConfigElementProvider implements
		IManagedConfigElementProvider {
	public final String EXTENSION_POINT_ID = "jp.pizzafactory.crosschains.managedConfigElementProvider"; //$NON-NLS-1$
	private final String projectTypeId;
	
	public DefaultManagedConfigElementProvider(String projectTypeId) {
		this.projectTypeId = projectTypeId;
	}
	
	public IManagedConfigElement[] getConfigElements() {
		IExtensionRegistry registry = Platform.getExtensionRegistry();
		IExtensionPoint extensionPoint =
			registry.getExtensionPoint(EXTENSION_POINT_ID);
		IExtension[] extensions = extensionPoint.getExtensions();
		IProjectType projectType =
			ManagedBuildManager.getExtensionProjectType(projectTypeId);
		for (int i = 0; i < extensions.length; i++) {
			IConfigurationElement[] elements =
				extensions[i].getConfigurationElements();
			boolean isEffective = false;
			ArrayList configList = new ArrayList();
			for (int j = 0; j < elements.length; j++) {
				if (elements[j].getName().equals("projectType")) { //$NON-NLS-1$
					if (elements[j].getAttribute("projectTypeId").equals(projectTypeId)) { //$NON-NLS-1$
						isEffective = true;
					}
				} else if (elements[j].getName().equals("configuration")) { //$NON-NLS-1$
					configList.add(elements[j]);
				}
			}
			if (isEffective) {
				IConfigurationElement[] configs = 
					(IConfigurationElement[]) configList.toArray(new IConfigurationElement[configList.size()]);
				IManagedConfigElement[] managedElements =
						DefaultManagedConfigElement.convertArray(configs, extensions[i]);
				for (int k = 0; k < managedElements.length; k++) {
					new Configuration((ProjectType) projectType, managedElements[k], "3.0.0"); //$NON-NLS-1$
				}
			}
			
		}

		return new IManagedConfigElement[0];
	}

}
