/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Intel Corporation - Initial API and implementation
 *******************************************************************************/
package jp.pizzafactory.crosschains.managedbuild.buildenv;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Set;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;

public class PizzaConfigurationEnvironmentCommonSupplier implements
		IConfigurationEnvironmentVariableSupplier {

	final Hashtable<String, IBuildEnvironmentVariable> envTable;

	public PizzaConfigurationEnvironmentCommonSupplier() {
		envTable = new Hashtable<String, IBuildEnvironmentVariable>();

		envTable.put("GCC_EXEC_PREFIX", new EnvVarRemove("GCC_EXEC_PREFIX"));
		envTable.put("GCC_VER", new EnvVarRemove("GCC_VER"));
	}

	public void addVariable(IBuildEnvironmentVariable variable) {
		envTable.put(variable.getName(), variable);
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier#getVariable(java.lang.String,
	 *      org.eclipse.cdt.managedbuilder.core.IConfiguration,
	 *      org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider)
	 */
	public IBuildEnvironmentVariable getVariable(String variableName,
			IConfiguration configuration, IEnvironmentVariableProvider provider) {

		Set<String> keySet = envTable.keySet();
		for (String name : keySet) {
			if (name.equalsIgnoreCase(variableName)) {
				return envTable.get(name);
			}
		}
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier#getVariables(org.eclipse.cdt.managedbuilder.core.IConfiguration,
	 *      org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider)
	 */
	public IBuildEnvironmentVariable[] getVariables(
			IConfiguration configuration, IEnvironmentVariableProvider provider) {
		Collection<IBuildEnvironmentVariable> collection = envTable.values();
		IBuildEnvironmentVariable[] vars = collection.toArray(new IBuildEnvironmentVariable[collection.size()]);
		return vars;
	}
}
