/*
 * Created on 2006/03/10
 *
 * Copyright (C) 2005- Monami software, LP.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Monami software, LP. - Initial API and implementation
 */
package jp.pizzafactory.crosschains;

import org.eclipse.cdt.make.internal.core.scannerconfig2.GCCSpecsRunSIProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;

public class PizzaGCCSpecsRunSIProvider extends GCCSpecsRunSIProvider {

	protected boolean initialize() {
		boolean rc = super.initialize();

		if (rc) {
			String cmdStr = buildInfo.getProviderRunCommand(providerId);
			IStringVariableManager variableManger = VariablesPlugin
					.getDefault().getStringVariableManager();
			try {
				cmdStr = variableManger.performStringSubstitution(cmdStr);
				fCompileCommand = new Path(cmdStr);
				rc = (fCompileCommand != null);
			} catch (CoreException e) {
				fCompileArguments = null;
				rc = false;
			}
		}

		return rc;
	}
}
