/*
 * Created on 2006/03/16
 *
 * Copyright (C) 2005- Monami software, LP.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Monami software, LP. - Initial API and implementation
 */
package jp.pizzafactory.crosschains;

import java.io.IOException;

import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import jp.pizzafactory.core.PathConverter;

public class PizzaBinPath {

	private final String searchBinPathFromBundle(Bundle bundle, String binPathName) throws IOException {
		String path = PathConverter.asShort(bundle, binPathName);
		if (path == null) {
			throw new IOException(Messages.getString("PizzaBinPath.PathNotFound")); //$NON-NLS-1$
		}
		return path;
	}

	public String getValue(Bundle pluginBundle, String binPathName) {
		try {
			return searchBinPathFromBundle(pluginBundle, binPathName);
		} catch (IOException e) {
			Bundle[] fragments = Platform.getFragments(pluginBundle);
			for (int i = 0; i < fragments.length; i++) {
				try {
					return searchBinPathFromBundle(fragments[i], binPathName);
				} catch (IOException e1) {
					/* not found */
				}
			}
		}
		return ""; //$NON-NLS-1$
	}
		
	public String getValue(Bundle pluginBundle) {
		return getValue(pluginBundle, "/pizza/bin"); //$NON-NLS-1$
	}
	
	
	public String getToolPath(Bundle pluginBundle, String arch) {
		String binPathName = "/pizza/" + arch + "/bin/";  //$NON-NLS-1$//$NON-NLS-2$
		return getValue(pluginBundle, binPathName);
	}
}
